<?php

class RfidUserPlot_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'urfid_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public static function get_company_filtered( $filter_company = NULL, $field_name = 'urfid_com_id' )
	{
		$filter = SQL::get_or_filter( $filter_company, $field_name );
		
		return '' != $filter ? ' AND ' . $filter : '';
	}
	
	public function delete( $urfid_id )
	{
		return $this->db->query( SQL::make_delete_pdo( 'rfid_user_plot', 'rup_urfid_id' ), array( $urfid_id ) );
	}
	
	public function add( $urfid_id, $plot )
	{
		$this->db->query( SQL::make_insert_pdo( 'rfid_user_plot', array( 'urfid_id', 'plot' ), '', 'rup_' ), array( $urfid_id, $plot ) );
		
		return $this->db->insert_id();
	}
	
	public function add_opt( $urfid_id, $plot )
	{
		$plots = explode( ',', $plot );
		
		if ( isset( $plots ) && !empty( $plots ) )
		{
			foreach ( $plots as $plot )
			{
				if ( !$this->in_plot( $plot, $urfid_id ) )
				{
					$this->add( $urfid_id, $plot );
				}
			}
		}
	}
	
	public function clean_and_add( $urfid_id, $arr_plot )
	{
		if ( is_array( $arr_plot ) && !empty( $arr_plot ) )
		{
			$arr_plot = array_unique( $arr_plot );
			
			$this->delete( $urfid_id );
			
			foreach ( $arr_plot as $plot )
			{
				$this->add( $urfid_id, $plot );
			}
		}
	}
	
	public function in_plot_user( $plot, $uid )
	{
		$plots = explode( ',', $plot );
		
		if ( isset( $plots ) && is_array( $plots ) && !empty( $plots ) )
		{
			foreach ( $plots as $plot )
			{
				if ( !$this->db->get_var( "SELECT 1 FROM rfid_user_plot INNER JOIN rfid_user ON urfid_id = rup_urfid_id WHERE rup_plot = ? AND urfid_uid = ?", array( $plot, $uid ) ) )
				{
					return FALSE;
				}
			}
			
			return TRUE;
		}
		
		return FALSE;
	}
	
	public function in_plot( $plot, $urfid_id )
	{
		$plots = explode( ',', $plot );
		
		if ( isset( $plots ) && is_array( $plots ) && !empty( $plots ) )
		{
			foreach ( $plots as $plot )
			{
				if ( !$this->db->get_var( "SELECT 1 FROM rfid_user_plot INNER JOIN rfid_user ON urfid_id = rup_urfid_id WHERE rup_plot = ? AND urfid_id = ?", array( $plot, $urfid_id ) ) )
				{
					return FALSE;
				}
			}
			
			return TRUE;
		}
		
		return FALSE;
	}
	
	public function has_owner( $plot, $filter_company = NULL )
	{
		$plot_sql = SQL::get_or_filter_exploded( $plot, 'rup_plot', ',' );
		
		$com_filter = self::get_company_filtered( $filter_company );
		
		return $this->db->get_var( "SELECT 1 FROM rfid_user_plot INNER JOIN rfid_user ON urfid_id = rup_urfid_id WHERE {$plot_sql} AND urfid_user_type = 1 {$com_filter}" );
	}
	
	public function has_plot( $urfid_id, $plot )
	{
		return $this->db->get_var( "SELECT 1 FROM rfid_user_plot WHERE rup_urfid_id = ? AND rup_plot = ?", array( $urfid_id, $plot ) );
	}
	
	public function has_owner_not_me( $plot, $urfid_id, $filter_company = NULL )
	{
		$plot_sql = SQL::get_or_filter_exploded( $plot, 'rup_plot', ',' );
		
		$com_filter = self::get_company_filtered( $filter_company );
		
		return $this->db->get_var( "SELECT 1 FROM rfid_user_plot INNER JOIN rfid_user ON urfid_id = rup_urfid_id WHERE {$plot_sql} AND urfid_user_type = 1 AND urfid_id != ? {$com_filter}", array( $urfid_id ) );
	}
	
	public function same_uid_plot( $uid, $urfid_id )
	{
		$sql = 'SELECT 1 FROM rfid_user_plot 
				WHERE	rup_urfid_id = ? AND 
						rup_plot IN ( SELECT rup_plot FROM rfid_user_plot INNER JOIN rfid_user ON urfid_id = rup_urfid_id WHERE urfid_uid = ? ) 
				LIMIT 1';
		
		return $this->db->get_var( $sql, array( $urfid_id, $uid ) );
	}
	
	public function get( $urfid_id )
	{
		return $this->db->get_results( 'SELECT * FROM rfid_user_plot WHERE rup_urfid_id = ?', ARRAY_A, array( $urfid_id ) );
	}
	
	public function get_arr( $urfid_id )
	{
		$plots = $this->get( $urfid_id );
		
		if ( isset( $plots ) )
		{
			$arr_plots = array();
			
			foreach ( $plots as $plot )
			{
				array_push( $arr_plots, $plot['rup_plot'] );
			}
			
			return $arr_plots;
		}
		
		return NULL; 
	}
}
