<?php
class RfidUserHours_model extends CI_Model
{	
	public function get( $urfid_id )
	{
		$this->db->set_qd( array( $urfid_id ) );
		
		return $this->db->get_results( 'SELECT * FROM rfid_user_hours WHERE ruh_urfid_id = ?' );
	}
	
	public function delete( $urfid_id )
	{
		return $this->db->query( 'DELETE FROM rfid_user_hours WHERE ruh_urfid_id = ?', array( $urfid_id ) );
	}
	
	public function add( $urfid_id, $day, $hour_init, $hour_end )
	{
		$fields = array( 'urfid_id', 'day', 'init', 'end' );
		$values = array( $urfid_id, $day, $hour_init, $hour_end );
		
		return $this->db->query( SQL::make_insert_pdo( 'rfid_user_hours', $fields, '', 'ruh_' ), $values );
	}
	
	public function save( $urfid_id, $form )
	{
		load_helper('hours');
		
		$this->db->trans_start();
		
		$this->delete( $urfid_id );
		
		foreach( HoursSlot::$DAYS as $day=>$day_n )
		{
			foreach( HoursSlot::$TURNS as $turn=>$turn_n )
			{
				$ini = sprintf("hours_%s_%s_%s", $turn, $day, 'ini');
				$fin = sprintf("hours_%s_%s_%s", $turn, $day, 'fin');
				
				$hour_init	= $form[$ini];
				$hour_end	= $form[$fin];
				$start		= strtotime('1970-1-1 ' . $hour_init);
				$end		= strtotime('1970-1-1 ' . $hour_end);
				
				if ( $turn == 'noc' && $hour_end == '00:00' )
				{
					$end		= strtotime('1970-1-2 ' . $hour_end);
				}

				if ( '' != $hour_init && '' != $hour_end && $end > $start )
				{
					$this->add( $urfid_id, $day, $hour_init, $hour_end );
				}
			}
		}
		
		$this->db->trans_complete();
	}
	
	public function build_hour_table( $urfid_id )
	{
		$arr = array();
		
		$hours = $this->get( $urfid_id );
		
		if ( isset( $hours ) )
		{
			foreach ( $hours as $hour )
			{
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->ruh_init, true ) . '_' . $hour->ruh_day . '_ini' ] = substr( $hour->ruh_init, 0, 5 );
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->ruh_end, false ) . '_' . $hour->ruh_day . '_fin' ] = substr( $hour->ruh_end , 0, 5 );
			}
		}
		
		return $arr;
	}
	
	public function hours_exists( $urfid_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM rfid_user_hours WHERE ruh_urfid_id = ? LIMIT 1', array( $urfid_id ) );
	}
	
	public function hours_get_day( $urfid_id, $day = 'today' )
	{
		if ( $day == 'today' )
		{
			$day = day2str( date( 'w' ) );
		}
		
		return $this->db->get_results( 'SELECT * FROM rfid_user_hours WHERE ruh_urfid_id = ? AND ruh_day = ?', ARRAY_A, array( $urfid_id, $day ) );
	}
	
	public function access_allowed( $urfid_id )
	{
		$hours	= $this->hours_get_day( $urfid_id );
		$now	= time();
		
		if ( isset( $hours ) )
		{
			foreach ( $hours as $hour )
			{
				$ini = strtotime( date( 'Y-m-d ' . $hour['ruh_init'] ) );
				$end = strtotime( date( 'Y-m-d ' . $hour['ruh_end']  ) );
				
				if ( $now >= $ini && $now <= $end )
				{
					return TRUE;
				}
			}
		}
		else
		{
			return NULL != $this->hours_exists( $urfid_id ) ? FALSE : TRUE;
		}
		
		return FALSE;
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'urfid_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function get_users_inside( $filter_company = NULL )
	{
		load_model('RfidUser_model');
		
		$where				= self::get_company_filter( $filter_company );
		$filter['filter']	= 'urfid_inside = 1 AND ( urfid_user_type = ' . RfIdUserType::NEIGHBOR_EMPLOYEE . ' OR urfid_user_type = ' . RfIdUserType::SERVICE . '
			OR urfid_user_type = ' . RfIdUserType::PROFESSIONAL . ' OR urfid_user_type = ' . RfIdUserType::WORKER . ' )';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( 'SELECT DISTINCT ruh_urfid_id AS urfid_id FROM rfid_user_hours INNER JOIN rfid_user ON urfid_id = ruh_urfid_id ' . $where, ARRAY_A ); 
	}
}
