<?php

class RfidUserCitymesh_model extends CI_Model
{
	public function delete( $uid )
	{
		return $this->db->query( SQL::make_delete_pdo( 'rfid_user_citymesh', 'ruc_uid' ), array( $uid ) );
	}
	
	public function add( $uid, $citymesh_id )
	{
		$this->db->query( SQL::make_insert_pdo( 'rfid_user_citymesh', array( 'uid', 'citymesh_id' ), '', 'ruc_' ), array( $uid, $citymesh_id ) );
		
		return $this->db->insert_id();
	}
	
	public function clean_and_add( $uid, $arr_citymesh )
	{
		if ( is_array( $arr_citymesh ) && !empty( $arr_citymesh ) )
		{
			$arr_citymesh = array_unique( $arr_citymesh );
			
			$this->delete( $uid );
			
			foreach ( $arr_citymesh as $citymesh_id )
			{
				$this->add( $uid, $citymesh_id );
			}
		}
	}
	
	public function get( $uid )
	{
		return $this->db->get_results( 'SELECT * FROM rfid_user_citymesh INNER JOIN rfid_citymesh ON ruc_citymesh_id = rc_id WHERE ruc_uid = ?', ARRAY_A, array( $uid ) );
	}
	
	public function get_array( $uid )
	{
		$codes = NULL;
		
		$rc_codes = $this->get( $uid );
		
		if ( isset( $rc_codes ) )
		{
			$codes = array();
			
			foreach ( $rc_codes as $rc_code )
			{
				$codes[] = $rc_code['rc_code'];
			}
		}
		
		return $codes;
	}
	
	public function get_citymesh_type_from_user( $uid, $type )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_user_citymesh INNER JOIN rfid_citymesh ON ruc_citymesh_id = rc_id WHERE ruc_uid = ? AND rc_type = ? LIMIT 1', ARRAY_A, array( $uid, $type ) );
	}
	
	public function get_citymesh_from_id_and_user( $uid, $id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_user_citymesh INNER JOIN rfid_citymesh ON ruc_citymesh_id = rc_id WHERE ruc_uid = ? AND ruc_citymesh_id = ? LIMIT 1', ARRAY_A, array( $uid, $id ) );
	}
}
