<?php

class InsurancePhotoState
{
	const NOT_VALIDATED = 0;
	const VALID = 1;
	const INVALID = 2;
}

class RfidPhoto_model extends CI_Model
{
	public function add( $path, $gallery_id, $state = 0, $name = '' )
	{
		$values = array( $path, $gallery_id, $state, $name );
		
		$this->db->query( SQL::make_insert_pdo( 'rfid_photo', array( 'path', 'gallery_id', 'state', 'name' ), '', 'rp_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function delete( $id )
	{
		$this->db->query( SQL::make_delete_pdo( 'rfid_photo', 'rp_id' ), array( $id ) );
	}
	
	public function unlink( $id )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid_photo', array( 'gallery_id', 'id' ), 'id', '', 'rp_' ), array( 0, $id ) );
	}
	
	public function delete_gallery( $id )
	{
		$this->db->query( SQL::make_delete_pdo( 'rfid_photo', 'rp_gallery_id' ), array( $id ) );
	}
	
	public function update_name( $id, $name )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid_photo', array( 'name', 'id' ), 'id', '', 'rp_' ), array( $name, $id ) );
	}
	
	
	public function get_unlinked( $id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_photo WHERE rp_id = ? LIMIT 1', ARRAY_A, array( $id ) );
	}
	
	public function get( $id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_photo 
												INNER JOIN rfid_gallery ON rp_gallery_id = rg_id 
												LEFT JOIN rfid_user ON urfid_id = rg_urfid_id
									WHERE rp_id = ? LIMIT 1', ARRAY_A, array( $id ) );
	}
	
	public function get_gallery_photos( $gallery_id )
	{
		return $this->db->get_results( 'SELECT * FROM rfid_photo WHERE rp_gallery_id = ?', ARRAY_A, array( $gallery_id ) );
	}
	
	public function get_gallery_photos_count( $gallery_id )
	{
		$count = $this->db->get_var( 'SELECT COUNT(*) AS count FROM rfid_photo WHERE rp_gallery_id = ?', array( $gallery_id ) );
		return NULL != $count ? $count : 0;
	}
	
	public function owns_rfid_from_company( $com_id, $id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid_photo 
												INNER JOIN rfid_gallery ON rp_gallery_id = rg_id 
												INNER JOIN rfid_user ON rg_urfid_id = urfid_id
											WHERE urfid_com_id = ? AND rp_id = ? LIMIT 1', array( $com_id, $id ) );
	}
	
	public function owns_rfid_from_df( $com_df_id, $id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid_photo 
												INNER JOIN rfid_gallery ON rp_gallery_id = rg_id 
												INNER JOIN rfid_user ON rg_urfid_id = urfid_id
												INNER JOIN company ON urfid_com_id = com_id 
											WHERE com_df_id = ? AND rp_id = ? LIMIT 1', array( $com_df_id, $id ) );
	}
	
	public function get_insurance_from( $urfid_id )
	{
		load_model('RfidGallery_model');
		
		return $this->db->get_row( 'SELECT rfid_photo.* FROM rfid_photo 
											INNER JOIN rfid_gallery ON rp_gallery_id = rg_id 
											INNER JOIN rfid_user ON rg_urfid_id = urfid_id
										WHERE 
											rg_type = ' . RfidGalleryType::INSURANCE . ' AND
											urfid_id = ?
											LIMIT 1', ARRAY_A, array( $urfid_id ) );
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'urfid_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'DISTINCT ON (rfid_user.urfid_name, rfid_user.urfid_id) rfid_user.*, rfid_photo.*, urfid_professional_name' )
	{
		$this->load->model('RfidUser_model');
		
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		$plotit		= !$is_count ? ', plot.urfid_plot' : '';
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . $plotit . '
				FROM rfid_photo
				INNER JOIN rfid_gallery ON rp_gallery_id = rg_id 
				INNER JOIN rfid_user ON rg_urfid_id = urfid_id ' . RfidUser_model::$basic_join . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function update_state( $id, $state )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid_photo', array( 'state', 'id' ), 'id', '', 'rp_' ), array( $state, $id ) );
	}
	
	public function basic_insurance_filter()
	{
		load_model('RfidGallery_model');
		
		$filter				= array(
			array(
				'field_name'	=>	'rg_type',
				'filter_val'	=>	RfidGalleryType::INSURANCE
			),
			array(
				'field_name'	=>	'rp_state',
				'filter_val'	=>	InsurancePhotoState::VALID,
				'filter_type'	=>	SQLFilterType::UNEQUALS
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
}
