<?php

class RfidGalleryType
{
	const GENERAL	= 0;
	const TOOLS		= 1;
	const INSURANCE	= 2;
}

class RfidGallery_model extends CI_Model
{
	public function exists_type( $urfid_id, $type )
	{
		return $this->db->get_var( 'SELECT rg_id FROM rfid_gallery WHERE rg_urfid_id = ? AND rg_type = ?', array( $urfid_id, $type ) );
	}
	
	public function add( $urfid_id, $type, $name = '' )
	{
		$values = array( $urfid_id, $type, $name );
		
		$this->db->query( SQL::make_insert_pdo( 'rfid_gallery', array( 'urfid_id', 'type', 'name' ), '', 'rg_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function update_name( $id, $name )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid_gallery', array( 'name', 'id' ), 'id', '', 'rg_' ), array( $name, $id ) );
	}
	
	public function get_id( $urfid_id, $type )
	{
		$id = $this->exists_type( $urfid_id, $type );
		
		return isset( $id ) ? $id : $this->add( $urfid_id, $type );
	}
	
	public function get_gallery_photos( $urfid_id, $type )
	{
		$id = $this->get_id( $urfid_id, $type );
		
		$RfidPhoto_model = load_model( 'RfidPhoto_model' );
		
		return $RfidPhoto_model->get_gallery_photos( $id );
	}
}
