<?php

class RfidCitymeshRestriction_model extends CI_Model
{
	public function get( $com_id, $user_type, $rc_id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_citymesh_restriction INNER JOIN rfid_citymesh ON rc_id = rcr_rc_id WHERE rc_com_id = ? AND rcr_user_type = ? AND rcr_rc_id = ?', ARRAY_A, array( $com_id, $user_type, $rc_id ) );
	}
	
	public function can_access( $com_id, $user_type, $rc_id )
	{
		$rcr = $this->get( $com_id, $user_type, $rc_id );
		
		return NULL == $rcr || $rcr['rcr_state'] == 1;
	}
	
	public function exists_user_type( $com_id, $user_type, $rc_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid_citymesh_restriction INNER JOIN rfid_citymesh ON rc_id = rcr_rc_id WHERE rc_com_id = ? AND rcr_user_type = ? AND rcr_rc_id = ?', array( $com_id, $user_type, $rc_id ) );
	}
	
	public function add( $user_type, $rc_id, $state = 1 )
	{
		$this->db->query( SQL::make_insert_pdo( 'rfid_citymesh_restriction', array( 'user_type', 'rc_id', 'state' ), '', 'rcr_' ), array( $user_type, $rc_id, $state ) );
		
		return $this->db->last_insert_id();
	}
	
	public function update( $user_type, $rc_id, $state = 1 )
	{
		$this->db->query( 'UPDATE rfid_citymesh_restriction SET rcr_state = ? WHERE rcr_rc_id = ? AND rcr_user_type = ?', array( $state, $rc_id, $user_type ) );
	}
	
	public function create_for_company( $com_id, $state = 1 )
	{
		load_model('RfidUser_model');
		load_model('RfidCitymesh_model');
		
		$citymeshs = $this->RfidCitymesh_model->get_all( $com_id );
		
		if ( isset( $citymeshs ) )
		{
			foreach ( $citymeshs as $citymesh )
			{
				$rc_id = $citymesh['rc_id'];
				
				for ( $user_type = RfIdUserType::FIRST; $user_type <= RfIdUserType::LAST; $user_type++ )
				{
					if ( !$this->exists_user_type( $com_id, $user_type, $rc_id ) )
					{
						$this->add( $user_type, $rc_id, $state );
					}
				}
			}
		}
	}
	
	public function reset_states( $com_id, $state = 0 )
	{
		$this->db->query( 'UPDATE rfid_citymesh_restriction SET rcr_state = ? WHERE rcr_rc_id IN ( SELECT rc_id FROM rfid_citymesh WHERE rc_com_id = ? )', array( $state, $com_id ) );
	}
	
	public function get_all( $com_id )
	{
		$this->create_for_company( $com_id );
		
		$sql = 'SELECT * FROM rfid_citymesh_restriction INNER JOIN rfid_citymesh ON rc_id = rcr_rc_id WHERE rc_com_id = ? ORDER BY rc_id ASC, rcr_user_type ASC';
		
		return $this->db->get_results( $sql, ARRAY_A, array( $com_id ) );
	}
	
	public function save_form( $com_id, $form )
	{
		$this->reset_states( $com_id );
		
		foreach ( $form as $key=>$data )
		{
			if ( -1 != str_starts_with( 'city_', $key ) )
			{
				$vals = explode( '_', substr( $key, 5 ) );
				
				if ( count( $vals ) == 2 )
				{
					$this->update( $vals[1], $vals[0] );
				}
			}
		}
	}
}
