<?php

class RfidCitymeshType
{
	const ENTRY		= 0x00;
	const LEAVE		= 0x01;
	const UNKNOWN	= 0x02;
	
	public static function from_event_type( $event_type )
	{
		switch ( $event_type )
		{
			case 0: return RfidCitymeshType::UNKNOWN;
			case 1: return RfidCitymeshType::ENTRY;
			case 2: return RfidCitymeshType::LEAVE;
		}
		
		return -1;
	}
	
	public static function to_event_type( $rc_type )
	{
		switch ( $rc_type )
		{
			case RfidCitymeshType::UNKNOWN: return 0x00; /* RfidEventType::UNKNOWN */
			case RfidCitymeshType::ENTRY: return 0x01; /* RfidEventType::ENTRY */
			case RfidCitymeshType::LEAVE: return 0x02; /* RfidEventType::LEAVE */
		}
		
		return RfidCitymeshType::UNKNOWN;
	}
	
	public static function is_entry( $rc_type )
	{
		return $rc_type == RfidCitymeshType::ENTRY ? 1 : 0;
	}
}

class RfidCitymesh_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'rc_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}

	public function add_cond( $code, $com_id )
	{
		if ( !$this->exists( $code, $com_id ) )
		{
			$values = array( $code, 'Equipo: ' . dechex( $code ), $com_id, RfidCitymeshType::UNKNOWN );
			
			$this->db->query( SQL::make_insert_pdo( 'rfid_citymesh', array( 'code', 'name', 'com_id', 'type' ), '', 'rc_' ), $values );
			
			return $this->db->insert_id();
		}
		
		return 0;
	}
	
	public function update_type( $code, $com_id, $type )
	{
		$this->db->query( 'UPDATE rfid_citymesh SET rc_type = ? WHERE rc_com_id = ? AND rc_code = ?' , array( $type, $com_id, $code ) );
	}
	
	public function update_name( $id, $name )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid_citymesh', array( 'name', 'id' ), 'id', '', 'rc_' ), array( $name, $id ) );
	}
	
	public function delete( $id )
	{
		$this->db->query( SQL::make_delete_pdo( 'rfid_citymesh', 'rc_id' ), array( $id ) );
	}
	
	public function get( $code, $com_id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_citymesh WHERE rc_code = ? AND rc_com_id = ?', ARRAY_A, array( $code, $com_id ) );
	}
	
	public function get_id( $rc_id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_citymesh WHERE rc_id = ?', ARRAY_A, array( $rc_id ) );
	}
	
	public function exists( $code, $com_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM rfid_citymesh WHERE rc_code = ? AND rc_com_id = ?', array( $code, $com_id ) );
	}
	
	public function get_all( $filter_company )
	{
		$where				= self::get_company_filter( $filter_company );
		
		SQL::prepare_filter( $where, NULL );
		
		return $this->db->get_results( 'SELECT * FROM rfid_citymesh ' . $where, ARRAY_A );
	}
}
