<?php

class Rfid_model extends CI_Model
{
	public static $fields = array( 'serial', 'user' );
	
	public function add_cond( $serial, $com_id )
	{
		if ( !$this->exists( $serial ) )
		{
			$this->db->set_qd( array( $serial, $com_id ) );
			
			$this->db->query( SQL::make_insert_pdo( 'rfid', array( 'serial', 'com_id' ), '', 'rfid_' ) );
			
			return $this->db->insert_id();
		}
	}
	
	public function update_person( $id, $urfid_id )
	{
		$this->db->query( SQL::make_update_pdo( 'rfid', array( 'user', 'serial' ), 'serial', '', 'rfid_' ), array( $urfid_id, $id ) );
	}
	
	public function exists( $serial )
	{
		return $this->db->get_var( 'SELECT 1 FROM rfid WHERE rfid_serial = ? LIMIT 1', array( $serial ) );
	}
	
	public function is_assigned_to_me( $serial, $urfid_id )
	{
		return $this->db->get_var( 'SELECT rfid_user FROM rfid WHERE rfid_serial = ? AND rfid_user = ?', array( $serial, $urfid_id ) );
	}
	
	public function is_assigned_to_other_person( $serial, $urfid_id )
	{
		return $this->db->get_var( 'SELECT rfid_user FROM rfid WHERE rfid_serial = ? AND rfid_user != ?', array( $serial, $urfid_id ) );
	}
	
	public function unassign_person( $serial )
	{
		$this->db->query( "UPDATE rfid SET rfid_user = NULL WHERE rfid_serial = ?", array( $serial ) );
	}
	
	public function unassign_person_by_urfid_id( $urfid_id )
	{
		$this->db->query( "UPDATE rfid SET rfid_user = NULL WHERE rfid_user = ?", array( $urfid_id ) );
	}
	
	public function owns_rfid( $uid, $rfid_serial )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid WHERE rfid_user = ? AND rfid_serial = ? LIMIT 1', array( $uid, $rfid_serial ) );
	}
	
	public function owns_rfid_from_company( $com_id, $rfid_serial )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid WHERE rfid_com_id = ? AND rfid_serial = ? LIMIT 1', array( $com_id, $rfid_serial ) );
	}
	
	public function owns_rfid_from_df( $com_df_id, $rfid_serial )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid INNER JOIN company ON rfid_com_id = com_id WHERE com_df_id = ? AND rfid_serial = ? LIMIT 1', array( $com_df_id, $rfid_serial ) );
	}
}
