<?php

class RequestTrackerType
{
	const SEND = 1;
	const SENDCFG = 2;
	const SENDCITYMESHCFG = 3;
	const SENDNOISECFG = 4;
	const SENDRFID = 5;
	const SENDKPANEL = 6;
	const QUERY = 7;
	const SENDGENERICMSG = 8;
	const NUCLEATIONDATA = 9;
}

class RequestTracker_model extends CI_Model
{
	const ACUMTIME = 300;
	
	public function add( $type, $com_id )
	{
		$this->db->query( SQL::make_insert_pdo( 'request_tracker', array( 'com_id', 'type', 'timestamp' ), '', 'rt_' ), array( $com_id, $type, time() ) );
	}
	
	public function get_all()
	{
		$time = "AND EXTRACT(epoch from now()) - rt_timestamp < " . self::ACUMTIME;
		
		$sql = "SELECT
				com_id,
				com_name,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id $time ) as total_requests,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 1 $time ) as send,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 2 $time ) as sendcfg,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 3 $time ) as sendcitymeshcfg,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 4 $time ) as sendnoisecfg,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 5 $time ) as sendrfid,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 6 $time ) as sendkpanel,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 7 $time ) as query,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 8 $time ) as sendgenericmsg,
				( SELECT COUNT(*) FROM request_tracker WHERE rt_com_id = com_id AND rt_type = 9 $time ) as nucleationdata
			FROM
				company
			ORDER BY
				total_requests DESC, com_name ASC
			";
			
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function clean()
	{
		$this->db->query( 'DELETE FROM request_tracker WHERE rt_timestamp < EXTRACT(epoch from now()) - ' . self::ACUMTIME );
	}
}
