<?php

class ReceiverTicksPeriod_model extends CI_Model
{
	public function get_ticks_from_time_range_query( $start_time, $end_time, $filter_company = NULL )
	{
		$filter = SQL::get_or_filter( $filter_company, 'rtp_com_id' );
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$filter_series = SQL::get_or_filter( $filter_company, 'com_id' );
		$filter_series = '' != $filter_series ? 'WHERE ' . $filter_series : '';
		
		$interval = RECEIVER_TICKS_PERIOD_TIME;
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	com_id,  
						generate_series AS time, 
						0 AS total, 
						com_name AS type
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN company ON TRUE
				$filter_series
				GROUP BY com_id, time, com_name, com_id
				ORDER BY generate_series ASC, com_name ASC ) AS base_series";
		
		
		$real_sql = "( SELECT	rtp_com_id AS com_id, rtp_from_time AS time, 
						SUM(rtp_ticks_count) AS total, 
						com_name AS type
				FROM receiver_ticks_period
				INNER JOIN company ON rtp_com_id = com_id
				WHERE rtp_from_time >= $start_time AND rtp_from_time < $end_time $filter
				GROUP BY rtp_com_id, rtp_from_time, com_name, com_id
				ORDER BY rtp_from_time ASC, com_name ASC ) AS real_series";
		
		
		$full_sql	=  "SELECT base_series.com_id, 
								base_series.time, 
								COALESCE(real_series.total,0) AS total, 
								base_series.type
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON base_series.time = real_series.time AND base_series.type = real_series.type";
		
		return $full_sql;
	}
	
	public function get_ticks_from_time_range_rows( $start_time, $end_time, $filter_company )
	{
		$sql = 'SELECT COUNT(DISTINCT q1.time) FROM (' . $this->get_ticks_from_time_range_query( $start_time, $end_time, $filter_company ) . ') AS q1';
		return $this->db->get_var( $sql );
	}
	
	public function get_ticks_from_time_range( $start_time, $end_time, $filter_company = NULL )
	{
		return $this->db->get_results( $this->get_ticks_from_time_range_query( $start_time, $end_time, $filter_company ), ARRAY_A );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM receiver_ticks_period WHERE rtp_com_id = ?', array( $com_id ) );
	}
}
