<?php
class ReceiverTicks_model extends CI_Model
{
	public function get_last( $com_id )
	{
		return $this->db->get_row( "SELECT rt_time AS last_tick, rt_id AS last_tick_id 
									FROM receiver_ticks 
									WHERE rt_company_id = ? 
									ORDER BY rt_id DESC LIMIT 1 OFFSET 0", 
									ARRAY_A, 
									array( $com_id )
		);
	}
	
	public function get_health( $com_id )
	{
		$this->db->set_qd( array( $com_id, 5*60 ) ); //5 min
		
		return $this->db->get_row( "SELECT COUNT(rt_id) as ct FROM receiver_ticks WHERE rt_company_id = ? AND ". SQL::secs_from_ts( 'rt_time' ) . " < ?", ARRAY_A );
	}
	
	public function get_health_percent( $com_id )
	{
		$health				= $this->get_health( $com_id );
		$health 			= $health['ct'];
		$tick_interval_s	= 2; //2 secconds, this MAY vary from company to company - we may need to take this var from elsewhere (reported by receiver, saved to company table...)
		$max_ticks			= 5 * ( 60 / $tick_interval_s );
		
		return min( ceil(($health / $max_ticks) * 100), 100 );
	}
	
	public function is_healthy( $cpy_id )
	{
		$this->db->set_qd( array($cpy_id) );
		
		$health = $this->db->get_row('SELECT rt_time FROM receiver_ticks WHERE rt_company_id = ? ORDER BY rt_id DESC LIMIT 1');

		if ( isset( $health ) )
		{
			if ( time() - strtotime( $health->rt_time ) < 600 ) // 10 mins
			{
				return true;
			}
		}
		
		return false;
	}

	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM receiver_ticks WHERE rt_company_id = ?', array( $com_id ) );
	}
}
