<?php
class ReceiverGeotraceLog_model extends CI_Model
{
	public function get( $last_id = NULL, $limit = 100 )
	{
		$filters = '';
		
		if( isset( $last_id ) ) 
		{
			$filters = "WHERE rgl_id > ?";
			$this->db->set_qd(array($last_id));
		}

		return $this->db->get_results("SELECT rgl_time AS time, rgl_msg AS msg, rgl_id as id FROM receiver_geotrace_log $filters ORDER BY rgl_id DESC LIMIT $limit OFFSET 0", ARRAY_A );
	}
	
	public function get_from( $from_time, $to_time )
	{
		return $this->db->get_results("SELECT rgl_time AS time, rgl_msg AS msg, rgl_id as id FROM receiver_geotrace_log WHERE rgl_time >= ? AND rgl_time <= ? ORDER BY rgl_id DESC", ARRAY_A, array( $from_time, $to_time ) );
	}
	
	public function add( $msg )
	{
		$this->db->query( SQL::make_insert_pdo( 'receiver_geotrace_log', array( 'msg' ), '', 'rgl_' ), array( $msg ) );
	}
}
