<?php
class ReceiverConsoleLog_model extends CI_Model
{
	public function get( $com_id, $last_id = NULL, $limit = 100 )
	{
		$filters = '';
		
		if( isset( $last_id ) ) 
		{
			$filters = "AND rcl_id > ?";
			$this->db->set_qd(array($com_id, $last_id));
		}
		else
		{
			$this->db->set_qd(array($com_id));
		}

		return $this->db->get_results("SELECT rcl_time AS time, rcl_msg AS msg, rcl_id as id FROM receiver_console_log WHERE rcl_company_id = ? ".$filters." ORDER BY rcl_id DESC LIMIT $limit OFFSET 0", ARRAY_A );
	}
	
	public function get_from( $com_id, $from_time, $to_time )
	{
		return $this->db->get_results("SELECT rcl_time AS time, rcl_msg AS msg, rcl_id as id FROM receiver_console_log WHERE rcl_company_id = ? AND rcl_time >= ? AND rcl_time <= ? ORDER BY rcl_id DESC", ARRAY_A, array( $com_id, $from_time, $to_time ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM receiver_console_log WHERE rcl_company_id = ?', array( $com_id ) );
	}
}
 
