<?php

class ReceiverCommand_model extends CI_Model
{
	public function add( $com_id, $cmd, $parameters )
	{
		$this->db->query( SQL::make_insert_pdo( 'receiver_command', array( 'com_id', 'cmd', 'parameters' ), '', 'rcmd_' ), array( $com_id, $cmd, $parameters ) );
	}
	
	public function get_pending_send( $filter_company )
	{
		$filter = array( 
			array(	'field_name' => 'rcmd_com_id', 
					'filter_val' => $filter_company 
			),
			array(	'field_name' => 'rcmd_status',
					'filter_val' => 0,
					'field_type' => SQLFieldType::INT
			)
		);
		
		$where = SQL::build_filter( $filter );
		
		return $this->db->get_results( "SELECT rcmd_id AS id, rcmd_cmd AS cmd, rcmd_parameters AS parameters FROM receiver_command $where ORDER BY rcmd_id ASC", ARRAY_A );
	}
	
	public function set_sent( $cmds )
	{
		if ( isset( $cmds ) && !empty( $cmds ) )
		{
			$ids = array();
			
			foreach ( $cmds as $cmd )
			{
				$ids[] = $cmd['id'];
			}
			
			$this->db->query( 'UPDATE receiver_command SET rcmd_status = 1 WHERE ' . SQL::get_or_filter( $ids, 'rcmd_id' ) );
		}
	}
}
