<?php
class Receipt_model extends CI_Model
{
	function exists( $date )
	{
		$db = db_get();

		$db->set_qd( array( $date ) );

		$res = $db->get_results( 'SELECT * FROM receipt WHERE re_date = ?' );

		return isset( $res );
	}

	function get( $uid, $order = 'ASC' )
	{
		$db = db_get();

		$db->set_qd( array( $uid ) );

		return $db->get_results( 'SELECT * FROM receipt WHERE re_user = ? ORDER BY re_date ' . $order );
	}

	function get_last( $uid )
	{
		$db = db_get();

		$db->set_qd( array( $uid ) );

		return $db->get_row( 'SELECT * FROM receipt WHERE re_user = ? ORDER BY re_date DESC LIMIT 1' );
	}

	function add( $uid, $date, $price )
	{
		$db = db_get();

		$db->trans_begin();

		$fields = array( 'user', 'date', 'amount' );

		$db->set_qd( array( $uid, $date, $price ) );

		$db->query( SQL::make_insert_pdo( 'receipt', $fields, '', 're_' ) );

		$db->set_qd( array( $price, $uid ) );

		$db->query( 'UPDATE users_info SET ui_balance = ui_balance - ? WHERE ui_uid = ?' );

		$db->trans_complete();
	}
}
