<?php

class RadarTest_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'rd_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function add( $com_id, $rd_id, $timestamp )
	{
		$this->db->query( SQL::make_insert_pdo( 'radar_test', array( 'com_id', 'rd_id', 'timestamp' ), '', 'rt_' ), array( $com_id, $rd_id, $timestamp ) );
	}
	
	public function get_all( $time_start, $time_end, $filter_company = NULL, $filter = NULL )
	{
		$where		= self::get_company_filter( $filter_company );
		SQL::prepare_filter( $where, SQL::build_query_filter( $filter ), FALSE );
		
		$sql = 'SELECT	radar.*,
						( SELECT COUNT(*) FROM radar_test WHERE rt_timestamp >= ' . $time_start . ' AND rt_timestamp <= ' . $time_end . ' AND rt_rd_id = rd_id ) AS count
				FROM radar
				INNER JOIN company ON com_id = rd_company ' . 
				$where;
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_rd_id( $time_start, $time_end, $rd_id, $filter = NULL )
	{
		if ( NULL == $filter ) $filter = array();
		
		$filter[] = array(	'field_name'	=>	'rd_id',
							'filter_val'	=>	$rd_id );
		
		return $this->get_all( $time_start, $time_end, NULL, $filter );
	}
	
	public function add_from_serial( $serial )
	{
		$this->load->model('Radar_model');
		
		$radar = $this->Radar_model->get_from_serial( $serial );
		
		if ( isset( $radar ) )
		{
			$this->add( $radar['rd_company'], $radar['rd_id'], time() );
		}
	}
} 
