<?php

class RadarLog_model extends CI_Model
{
	public function add( $com_id, $timestamp, $message, $serial = NULL )
	{
		$this->db->query( "INSERT INTO radar_log ( rl_com_id, rl_timestamp, rl_msg, rl_serial ) VALUES ( ?, " . SQL::from_unix_time( '?' ) . ", ?, ? )", array( $com_id, $timestamp, $message, $serial ) );
	}
	
	public function add_batch( $com_id, $serial, $logs )
	{
		if ( isset( $logs ) && !empty( $logs ) )
		{
			$batch = array();
			
			foreach( $logs as $log )
			{
				$batch[] = array(
					'rl_com_id' => $com_id,
					'rl_serial' => $serial,
					'rl_timestamp' => SQL::timestamp_to_db_format( $log[1] ),
					'rl_msg' => $log[2]
				);
			}
			
			$this->db->insert_batch( 'radar_log', $batch );
		}
	}
	
	public function get( $filter_company = NULL, $last_id = NULL, $limit = 100 )
	{
		$filter = array(
			array(
				'field_name' => 'rl_id',
				'filter_val' => $last_id,
				'filter_type' => SQLFilterType::BIGGER
			),
			array(
				'field_name' => 'rl_com_id',
				'filter_val' => $filter_company
			)
		);
		
		$where = SQL::build_filter( $filter );
		
		return $this->db->get_results("SELECT rl_timestamp AS time, rl_msg AS msg, rl_id as id, rl_serial as serial FROM radar_log $where ORDER BY rl_id DESC LIMIT $limit OFFSET 0", ARRAY_A );
	}
	
	public function get_last( $filter_company )
	{
		$filter = array(
			array(
				'field_name' => 'rl_com_id',
				'filter_val' => $filter_company
			)
		);
		
		$where = SQL::build_filter( $filter );
		
		return $this->db->get_row( "SELECT rl_timestamp AS last_tick, rl_id AS last_tick_id 
									FROM radar_log 
									$where
									ORDER BY rl_id DESC 
									LIMIT 1 
									OFFSET 0", 
									ARRAY_A
		);
	}
	
	public function get_from( $filter_company = NULL, $from_time, $to_time )
	{
		$filter = array(
			array(
				'field_name' => 'rl_timestamp',
				'filter_val' => $from_time,
				'filter_type' => SQLFilterType::BIGGER_OR_EQ
			),
			array(
				'field_name' => 'rl_timestamp',
				'filter_val' => $to_time,
				'filter_type' => SQLFilterType::SMALLER_OR_EQ
			),
			array(
				'field_name' => 'rl_com_id',
				'filter_val' => $filter_company
			)
		);
		
		$where = SQL::build_filter( $filter );
		
		return $this->db->get_results("SELECT rl_timestamp AS time, rl_msg AS msg, rl_id as id, rl_serial as serial FROM radar_log $where ORDER BY rl_id DESC", ARRAY_A, array( $from_time, $to_time ) );
	}
} 
