<?php
class RadarEventType
{
	const INFRACTION	= 0;
	const TEST			= 1;
}

class RadarEventStatus
{
	const NOT_VALIDATED = 0;
	const VALID			= 1;
	const INVALID		= 2;
}

class RadarEventUploadStatus
{
	const NOT_UPLOADED	= 0;
	const UPLOADED		= 1;
	const NOT_REQUIRED	= 2;
}

/** TABLE REFERENCE
	re_id serial NOT NULL,
	re_rd_serial bigint NOT NULL,
	re_country_id integer,
	re_image character varying(64) NOT NULL DEFAULT ''::character varying,
	re_timestamp bigint NOT NULL,
	re_max_speed integer NOT NULL,
	re_speed integer,
	re_type integer NOT NULL,
 **/
class RadarEvent_model extends CI_Model
{
	public static $fields = array( 'rd_serial', 'country_id', 'image', 'timestamp', 'max_speed', 'speed', 'type' );
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'rd_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function add( $rd_serial, $country_id, $image, $timestamp, $max_speed, $speed, $type )
	{
		$this->db->query( SQL::make_insert_pdo( 'radar_event', self::$fields, '', 're_' ), func_get_args() );
		
		return $this->db->insert_id();
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function exists( $serial, $timestamp )
	{
		return $this->db->get_var( 'SELECT 1 FROM radar_event WHERE re_rd_serial = ? AND re_timestamp = ? LIMIT 1', array( $serial, $timestamp ) );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'radar_event.*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM radar_event INNER JOIN radar ON rd_serial = re_rd_serial INNER JOIN company ON com_id = rd_company ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function get_from_radar_serial( $rd_serial, $per_page = NULL, $page_num = 1 )
	{
		$fields = array(
			array(
				'field_name'	=>	're_rd_serial',
				'filter_val'	=>	$rd_serial
			),
			array(
				'field_name'	=>	're_valid',
				'filter_val'	=>	1
			),
			array(
				'order_by'		=>	're_id',
				'order_dir'		=>	'DESC'
			)
		);
		
		return $this->get_all( NULL, SQL::build_query_filter( $fields ), $per_page, $page_num );
	}
	
	public function get_from_radar( $rd_id, $per_page = NULL, $page_num = 1 )
	{
		$fields = array(
			array(
				'field_name'	=>	'rd_id',
				'filter_val'	=>	$rd_id
			),
			array(
				'field_name'	=>	're_valid',
				'filter_val'	=>	1
			),
			array(
				'order_by'		=>	're_timestamp',
				'order_dir'		=>	'DESC'
			)
		);
		
		return $this->get_all( NULL, SQL::build_query_filter( $fields ), $per_page, $page_num );
	}
	
	public function get( $re_id )
	{
		return $this->db->get_row( 'SELECT * FROM radar_event 
									INNER JOIN radar ON rd_serial = re_rd_serial 
									INNER JOIN company ON com_id = rd_company 
									WHERE re_id = ?', ARRAY_A, array( $re_id ) );
	}
	
	public function update_state( $re_id, $valid )
	{
		$this->db->query( SQL::make_update_pdo( 'radar_event', array( 'valid', 'id' ), 'id', '', 're_' ), array( $valid, $re_id ) );
	}
	
	public function update_plate( $re_id, $plate )
	{
		$this->db->query( SQL::make_update_pdo( 'radar_event', array( 'plate', 'id' ), 'id', '', 're_' ), array( $plate, $re_id ) );
	}
	
	public function update_upload_state( $re_id, $state )
	{
		$this->db->query( SQL::make_update_pdo( 'radar_event', array( 'upload_state', 'id' ), 'id', '', 're_' ), array( $state, $re_id ) );
	}
	
	public function update_image( $re_id, $image )
	{
		$this->db->query( SQL::make_update_pdo( 'radar_event', array( 'image', 'id' ), 'id', '', 're_' ), array( $image, $re_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM radar_event WHERE re_rd_serial IN ( SELECT rd_serial FROM radar WHERE rd_company = ? )', array( $com_id ) );
	}
}
