<?php
class Radar_model extends CI_Model
{
	public static $fields = array( 'name', 'lat', 'long', 'company', 'serial', 'trigger_speed', 'urbanization_name', 'urbanization_address' );
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'rd_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function has_radar( $filter_company )
	{
		$where		= self::get_company_filter( $filter_company );
		
		if ( '' == $where )
		{
			$where = 'FALSE';
		}
		
		return NULL != $this->db->get_var( 'SELECT 1 FROM radar WHERE ' . $where . ' LIMIT 1' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'radar.*, com_apikey' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM radar INNER JOIN company ON com_id = rd_company ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}

	public function add( $name, $lat, $long, $company, $serial, $trigger_speed, $urbanization_name, $urbanization_address, $host_addr )
	{
		$this->db->set_qd( array( $name, $lat, $long, $company, $serial, $trigger_speed, $urbanization_name, $urbanization_address, $host_addr ) );
		
		$fields = self::$fields;
		
		array_push( $fields, 'host_addr' );
		
		$this->db->query( SQL::make_insert_pdo( 'radar', $fields, '', 'rd_' ) );
		
		return $this->db->insert_id();
	}
	
	public function update( $id, $name, $lat, $long, $company, $serial, $trigger_speed, $urbanization_name, $urbanization_address )
	{
		$this->db->set_qd( array( $name, $lat, $long, $company, $serial, $trigger_speed, $urbanization_name, $urbanization_address, $id ) );
		
		$fields = self::$fields;
		
		array_push( $fields, 'id' );
		
		$this->db->query( SQL::make_update_pdo( 'radar', $fields, 'id', '', 'rd_' ) );
	}
	
	public function update_config( $id, $country_id, $speed_ignore, $photo_timeout_ms, $photo_count, $photo_index, $host_addr, $api_key )
	{
		$fields = array( 'country_id', 'speed_ignore', 'photo_timeout_ms', 'photo_count', 'photo_index', 'host_addr', 'api_key', 'id' );
		$values = array( $country_id, $speed_ignore, $photo_timeout_ms, $photo_count, $photo_index, $host_addr, $api_key, $id );
		
		$this->db->query( SQL::make_update_pdo( 'radar', $fields, 'id', '', 'rd_' ), $values );
	}
	
	public function update_logo( $id, $urbanization_logo )
	{
		$this->db->query( SQL::make_update_pdo( 'radar', array( 'urbanization_logo', 'id' ), 'id', '', 'rd_' ), array( $urbanization_logo, $id ) );
	}
	
	public function update_api_key( $id, $api_key )
	{
		$this->db->query( SQL::make_update_pdo( 'radar', array( 'api_key', 'id' ), 'id', '', 'rd_' ), array( $api_key, $id ) );
	}
	
	public function delete( $id )
	{
		$this->db->trans_start();
		$this->db->query( 'DELETE FROM radar_event WHERE re_rd_serial IN ( SELECT rd_serial FROM radar WHERE rd_id = ? )', array( $id ) );
		$this->db->query( 'DELETE FROM radar_test WHERE rt_rd_id = ?', array( $id ) );
		$this->db->query( 'DELETE FROM radar WHERE rd_id = ?', array( $id ) );
		$this->db->trans_commit();
	}
	
	public function get( $id )
	{
		return $this->db->get_row( "SELECT * FROM radar WHERE rd_id = ? LIMIT 1", ARRAY_A, array( $id ) );
	}
	
	public function get_from_serial( $serial )
	{
		return $this->db->get_row( "SELECT * FROM radar WHERE rd_serial = ? LIMIT 1", ARRAY_A, array( $serial ) );
	}
	
	public function exists( $id )
	{
		return $this->db->get_var( 'SELECT 1 FROM radar WHERE rd_id = ? LIMIT 1', array( $id ) );
	}
	
	public function exists_serial( $serial )
	{
		return $this->db->get_var( 'SELECT 1 FROM radar WHERE rd_serial = ? LIMIT 1', array( $serial ) );
	}
	
	public function get_serial( $rd_id )
	{
		return $this->db->get_var( 'SELECT rd_serial FROM radar WHERE rd_id = ?', array( $rd_id ) );
	}
	
	public function get_all_serials( $filter_company, $rd_serial = NULL )
	{
		$where				= self::get_company_filter( $filter_company );
		$filter['filter']	= NULL != $rd_serial ? "to_hex(rd_serial) ILIKE '%" . SQL::escape_string( $rd_serial ) . "%'" : '';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT rd_id, rd_company, to_hex(rd_serial) AS rd_serial FROM radar $where", ARRAY_A );
	}
	
	public function update_max_speed( $rd_id, $max_speed )
	{
		$this->db->set_qd( array( $trigger_speed, $rd_id ) );
		
		$this->db->query( SQL::make_update_pdo( 'radar', array( 'trigger_speed', 'id' ), 'id', '', 'rd_' ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM radar WHERE rd_company = ?', array( $com_id ) );
	}
	
	public function company_owns( $com_id, $rd_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM radar WHERE rd_company = ? AND rd_id = ? LIMIT 1', array( $com_id, $rd_id ) );
	}
	
	public function company_owns_from_df( $com_df_id, $rd_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT rd_company FROM radar WHERE rd_id = ? LIMIT 1 )', array( $com_df_id, $rd_id ) );
	}
}
