<?php
class MacsIcons_model extends CI_Model
{
	public static $fields = array( 'serial', 'icon' );
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= '';
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM macs_icons ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}

	public function add( $serial, $icon )
	{
		$this->db->set_qd( array( $serial, $icon ) );
		
		$this->db->query( SQL::make_insert_pdo( 'macs_icons', self::$fields, '', 'mac_' ) );
	}
	
	public function edit( $serial, $icon )
	{
		$this->db->set_qd( array( $icon, $serial ) );
		
		$this->db->query( SQL::make_update_pdo( 'macs_icons', self::$fields, 'serial', '', 'mac_' ) );
	}
	
	public function delete( $serial )
	{
		$this->db->set_qd( array( $serial ) );
		
		$this->db->query( 'DELETE FROM macs_icons WHERE mac_serial = ?' );
	}
	
	public function get( $serial )
	{
		$this->db->set_qd( array( $serial ) );
		
		return $this->db->get_row( 'SELECT * FROM macs_icons WHERE mac_serial = ?' );
	}
	
	public function exists( $serial )
	{
		return $this->get( $serial );
	}
	
	public function get_icon( $serial, $delete_on_found = FALSE )
	{
		$mac = $this->exists( $serial );
		
		if ( null != $mac )
		{
			if ( $delete_on_found )
			{
				$this->delete( $serial );
			}
			
			return $mac->mac_icon;
		}
		
		return 'INTERIOR';
	}
}
