<?php
class Location_model extends CI_Model
{
	public static $fields = array( 'name', 'desc' );
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= '';
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM locations ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}

	public function add( $name, $desc )
	{
		$this->db->set_qd( array( $name, $desc ) );
		
		$this->db->query( SQL::make_insert_pdo( 'locations', self::$fields, '', 'loc_' ) );
		
		return $this->db->insert_id();
	}
	
	public function edit( $id, $name, $desc )
	{
		$this->db->set_qd( array( $name, $desc, $id ) );
		
		$fields = self::$fields;
		
		array_push( $fields, 'id' );
		
		$this->db->query( SQL::make_update_pdo( 'locations', $fields, 'id', '', 'loc_' ) );
	}
	
	public function delete( $id )
	{
		$this->db->set_qd( array( $id ) );
		
		$this->db->query( 'DELETE FROM locations WHERE loc_id = ?' );
	}
	
	public function get_cities_array()
	 {
		$places = array();
		
		$res = $this->db->get_results( 'SELECT * FROM locations ORDER BY loc_name ASC' );
		
		if ( $this->db->num_rows > 0 )
		{
			foreach( $res as $row )
			{
				$places[ $row->loc_id ] = $row->loc_name . ' ('.$row->loc_desc.')';
			}
		}
		
		return $places;
	}
	
	public function get( $id )
	{
		return $this->db->get_row( "SELECT * FROM locations WHERE loc_id = ? LIMIT 1", ARRAY_A, array( $id ) );
	}
	
	public function get_fullname( $id )
	{
		return $this->db->get_var( "SELECT loc_name || ' ( ' || loc_desc || ' )' FROM locations WHERE loc_id = ?", array( $id ) );
	}
	
	public function exists( $id )
	{
		return $this->db->get_var( 'SELECT 1 FROM locations WHERE loc_id = ? LIMIT 1', array( $id ) );
	}
}
