<?php
class KPanelMsgSend_model extends CI_Model
{
	/*
		kms_id bigserial NOT NULL,
		kms_hw_serial bigint,
		kms_hw_code integer,
		kms_msg_id smallint,
		kms_partition smallint,
		kms_reports_num smallint,
		kms_msg character varying(32),
		kms_raw bytea,
		kms_state message_status DEFAULT 'PENDING_SEND'::message_status,
		kms_com_id integer NOT NULL,
	*/
	
	public function add( $com_id, $frame_fields, $frame_raw = NULL )
	{
		$fields = array_keys( $frame_fields ); $fields[] = 'raw'; $fields[] = 'com_id';
		$raw_val = NULL;
		
		if ( isset( $frame_raw ) )
		{
			$raw_val = SQL::byte_array_to_bytea( $frame_raw );
		}
		
		$values = array_values( $frame_fields ); $values['raw'] = $raw_val; $values['com_id'] = $com_id;
		
		$this->db->query( SQL::make_insert_pdo( 'kpanel_msg_send', $fields, '', 'kms_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function get( $kms_id )
	{
		return $this->db->get_row( 'SELECT kpanel_msg_send.*, hardware.hw_id FROM kpanel_msg_send INNER JOIN hardware ON hw_serial = kms_hw_serial WHERE kms_id = ?', ARRAY_A, array( $kms_id ) );
	}
	
	public function get_all()
	{
		return $this->db->get_results( 'SELECT * FROM kpanel_msg_send', ARRAY_A );
	}
	
	public function get_pending( $com_id )
	{
		return $this->db->get_results( "SELECT * FROM kpanel_msg_send WHERE kms_com_id = ? AND kms_state = 'PENDING_SEND'", ARRAY_A, array( $com_id ) );
	}
	
	public function set_state( $kms_id, $state )
	{
		$this->db->query( "UPDATE kpanel_msg_send SET kms_state = ? WHERE kms_id = ?", array( $state, $kms_id ) );
	}
	
	
	public function set_waiting_response( $kms_id )
	{
		$this->set_state( $kms_id, 'WAITING_RESPONSE' );
	}
	
	public function set_state_on_response( $com_id, $msg_id, $state = 'EXECUTED' )
	{
		$kms_id = $this->db->get_var( 'SELECT kms_id FROM kpanel_msg_send WHERE kms_com_id = ? AND kms_msg_id = ? ORDER BY kms_id DESC LIMIT 1', array( $com_id, $msg_id ) );
		
		if ( isset( $kms_id ) )
		{
			$this->set_state( $kms_id, $state );
		}
	}
	
	public function send_message( $com_id, $hw_serial, $partition, $reports_num, $msg, $start_new_queue = FALSE )
	{
		$msg_id = $start_new_queue ? 0 : $this->get_next_msg_id( $com_id, $hw_serial );
		
		$fields = array(
			'hw_serial' => $hw_serial,
			'hw_code' => 0x00,
			'msg_id' => $msg_id,
			'partition' => $partition,
			'reports_num' => $reports_num,
			'msg' => $msg
		);
		
		return $this->add( $com_id, $fields );
	}
	
	public function send_initialization( $com_id, $hw_serial )
	{
		$msg[] = 0xB4;
		$msg[] = 0xB4;
		
		return $this->send_message( $com_id, $hw_serial, 0x01, 60, byte_array_to_hexa( $msg ), TRUE );
	}
	
	public function get_current_msg_id( $com_id, $hw_serial )
	{
		$max = $this->db->get_var( 'SELECT kms_msg_id FROM kpanel_msg_send WHERE kms_com_id = ? AND kms_hw_serial = ? ORDER BY kms_id DESC LIMIT 1', array( $com_id, $hw_serial ) );
		
		return isset( $max ) ? $max : 0;
	}
	
	public function get_next_msg_id( $com_id, $hw_serial )
	{
		$cur = $this->get_current_msg_id( $com_id, $hw_serial );
		
		if ( $cur < 0xFF )
		{
			return $cur + 1;
		}
		
		return 1;
	}
}
