<?php

require_once(LIBSPATH.'frames/frame_utils.php');

class KPanelMsgReceived_model extends CI_Model
{
	/*
		kmr_id bigserial NOT NULL,
		kmr_hw_serial bigint,
		kmr_hw_code integer,
		kmr_secuence smallint,
		kmr_age smallint,
		kmr_jump smallint,
		kmr_prefix smallint,
		kmr_flags smallint,
		kmr_fixed_flag smallint,
		kmr_msg_id smallint,
		kmr_partition smallint,
		kmr_partition_mask integer,
		kmr_partition_state smallint,
		kmr_led_state integer,
		kmr_sound_state smallint,
		kmr_raw bytea,
		kmr_com_id integer NOT NULL,
	* */
	
	public function add( $com_id, $frame_fields, $frame_raw )
	{
		if ( isset( $frame_fields['state'] ) )
		{
			unset( $frame_fields['state'] );
		}
		
		$fields = array_keys( $frame_fields ); $fields[] = 'raw'; $fields[] = 'com_id';
		
		$raw_val = SQL::byte_array_to_bytea( $frame_raw );
		
		$values = array_values( $frame_fields ); $values['raw'] = $raw_val; $values['com_id'] = $com_id;
		
		$this->db->query( SQL::make_insert_pdo( 'kpanel_msg_received', $fields, '', 'kmr_' ), $values );
	}
	
	public function get_all()
	{
		return $this->db->get_results( 'SELECT *, EXTRACT(EPOCH FROM kmr_timestamp)::bigint AS timestamp FROM kpanel_msg_received', ARRAY_A );
	}
	
	public function get_new_messages( $hw_id, $from_time )
	{
		return $this->db->get_results( 'SELECT kpanel_msg_received.*, EXTRACT(EPOCH FROM kmr_timestamp)::bigint AS timestamp
										FROM kpanel_msg_received 
										INNER JOIN hardware ON hw_serial = kmr_hw_serial 
										WHERE hw_id = ? AND EXTRACT(EPOCH FROM kmr_timestamp)::bigint > ?
										ORDER BY kmr_timestamp ASC', ARRAY_A, array( $hw_id, $from_time ) );
	}
	
	public function get_new_messages_timestamp( $hw_id, $from_time )
	{
		return $this->get_new_messages( $hw_id, $from_time );
	}
	
	public function get_message_response( $hw_id, $msg_id )
	{
		return $this->db->get_row( 'SELECT kpanel_msg_received.*, EXTRACT(EPOCH FROM kmr_timestamp)::bigint AS timestamp
										FROM kpanel_msg_received 
										INNER JOIN hardware ON hw_serial = kmr_hw_serial 
										WHERE hw_id = ? AND kmr_msg_id = ? ORDER BY kmr_id DESC LIMIT 1', ARRAY_A, array( $hw_id, $msg_id ) );
	}
	
	public function get_last_message( $hw_id )
	{
		return $this->db->get_row( 'SELECT kpanel_msg_received.*, EXTRACT(EPOCH FROM kmr_timestamp)::bigint AS timestamp
										FROM kpanel_msg_received 
										INNER JOIN hardware ON hw_serial = kmr_hw_serial 
										WHERE hw_id = ?
										ORDER BY kmr_timestamp DESC
										LIMIT 1', ARRAY_A, array( $hw_id ) );
	}
	
	public function exists_panel( $hw_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM kpanel_msg_received INNER JOIN hardware ON hw_serial = kmr_hw_serial WHERE hw_id = ? LIMIT 1', array( $hw_id ) );
	}
}
