<?php
class Keychain_model extends CI_Model
{
	public static $fields		= array(	'id', 'owner_name', 'owner_lastname', 'owner_dni', 'owner_phone', 'owner_phone_alt', 
											'owner_cellphone', 'owner_mail', 'observations', 'group', 'company' );
	
	public static $fieldstpl	= array( 	'key_uid', 'key_button', 'description', 'sms', 'contact' );
	
	public static $fieldsev		= array(	'key_id', 'key_company', 'button', 'timestamp', 'hw_serial' );
	
	public function get( $key_uid )
	{
		return $this->db->get_row( 'SELECT * FROM keychain WHERE key_uid = ?', ARRAY_A, array( intval( $key_uid ) ) );
	}
	
	public function get_by_id( $key_id, $com_id = NULL )
	{
		if ( NULL == $com_id )
		{
			$com_id = User()->get_type_id();
		}
		
		return $this->db->get_row( 'SELECT * FROM keychain WHERE key_id = ? AND key_company = ?', ARRAY_A, array( intval( $key_id ), intval( $com_id ) ) );
	}
	
	public function count_by_id( $key_id, $com_id = NULL )
	{
		if ( NULL == $com_id )
		{
			$com_id = User()->get_type_id();
		}
		
		return $this->db->get_var( 'SELECT COUNT(*) AS count FROM keychain WHERE key_id = ? AND key_company = ?', array( intval( $key_id ), intval( $com_id ) ) );
	}
	
	public function add( $form )
	{
		$form['id']			= $form['key_id'];
		
		$this->db->query( SQL::make_insert_pdo( 'keychain', self::$fields, '', 'key_' ), get_field_values_from_form( self::$fields, $form ) );
		
		return $this->db->insert_id();
	}

	public function edit( $form )
	{
		$form['id']			= $form['key_id'];
		
		$fields				= self::$fields;
		
		array_push( $fields, 'uid' );
		
		return $this->db->query( SQL::make_update_pdo( 'keychain', $fields, 'uid', '', 'key_' ), get_field_values_from_form( $fields, $form ) );
	}
	
	/** could be an array of companies or just a com_id */
	public static function get_company_filter( $filter_company = NULL, $field_name = 'key_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM keychain 
				LEFT JOIN users_info ON key_user = ui_uid 
				LEFT JOIN users ON key_user = uid ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function delete( $key_uid )
	{
		$this->delete_tpl( $key_uid );
		
		$this->db->query( 'DELETE FROM keychain WHERE key_uid = ?', array( $key_uid ) );
	}
	
	public function get_key_tpl( $key_uid, $button = NULL )
	{
		if ( NULL != $button )
		{
			return $this->db->get_row( 'SELECT * FROM keychain_template WHERE ktpl_key_uid = ? AND ktpl_key_button = ?', ARRAY_A, array( $key_uid, $button ) );
		}
		else
		{
			return $this->db->get_results( 'SELECT * FROM keychain_template WHERE ktpl_key_uid = ? ORDER BY ktpl_id ASC', ARRAY_A, array( $key_uid ) );
		}
	}
	
	public function get_key_tpl_by_id( $key_id, $com_id )
	{
		return $this->db->get_results( 'SELECT * FROM keychain_template INNER JOIN keychain ON ktpl_key_uid = key_uid WHERE key_id = ? AND key_company = ? ORDER BY ktpl_id ASC', ARRAY_A,
								array( $key_id, $com_id ) );
	}
	
	private function get_key_tpl_tmp_form( $form, $button, $id = NULL )
	{
		$nform					= array();
		$nform['key_uid']		= $form['key_uid'];
		$nform['key_button']	= $button;
		$nform['description']	= $form["description_$button"];
		$nform['sms']			= $form["sms_$button"];
		$nform['contact']		= $form["contact_$button"];
		$nform['id']			= $id;
		return $nform;
	}
	
	public function update_tpl( $form )
	{
		for ( $i = 1; $i <= 4; $i++ )
		{
			$ktpl = self::get_key_tpl( $form['key_uid'], $i );
			
			if ( isset( $ktpl ) && !empty( $ktpl ) )
			{
				self::edit_tpl( self::get_key_tpl_tmp_form( $form, $i, $ktpl['ktpl_id'] ) );
			}
			else
			{
				self::add_tpl( self::get_key_tpl_tmp_form( $form, $i ) );
			}
		}
	}
	
	public function add_tpl( $form )
	{
		return $this->db->query( SQL::make_insert_pdo( 'keychain_template', self::$fieldstpl, '', 'ktpl_' ), get_field_values_from_form( self::$fieldstpl, $form ) );
	}

	public function edit_tpl( $form )
	{
		$fields = self::$fieldstpl; array_push( $fields, 'id' );
		
		return $this->db->query( SQL::make_update_pdo( 'keychain_template', $fields, 'id', '', 'ktpl_' ), get_field_values_from_form( $fields, $form ) );
	}
	
	public function delete_tpl( $key_uid )
	{
		$this->db->query( 'DELETE FROM keychain_template WHERE ktpl_key_uid = ?', array( $key_uid ) );
	}
	
	public function valid_event( $key_id, $com_id, $button, $timestamp, $hw_serial )
	{
		$total = $this->db->get_var( 'SELECT COUNT(*) AS total FROM keychain_events INNER JOIN keychain ON key_id = kev_key_id WHERE kev_key_id = ? AND kev_key_company = ? AND kev_button = ? AND kev_hw_serial = ? AND kev_timestamp > ( ? - 60 )',
								array( $key_id, $com_id, $button, $hw_serial, $timestamp ) );
		
		return 0 == $total;
	}
	
	public function add_event( $key_id, $com_id, $button, $timestamp, $hw_serial )
	{
		$this->db->query( SQL::make_insert_pdo( 'keychain_events', self::$fieldsev, '', 'kev_' ), array( $key_id, $com_id, $button, $timestamp, $hw_serial ) );
		
		return $this->db->insert_id();
	}
	
	public function get_active_not_registered( $com_id, $secs = 60 )
	{
		$q = '';
		$a = null;
		
		if ( 0 != $com_id )
		{
			$q = 'AND kev_key_company = ?';
			$a = array( $com_id );
		} 
		
		$sql = "	SELECT 
						kev_key_id as id, 
						hw_address as address
					FROM keychain_events 
					LEFT JOIN hardware ON hw_serial = kev_hw_serial
					WHERE
						kev_key_id NOT IN (SELECT key_id FROM keychain) " . $q . " AND " . 
						SQL::from_unix_time('kev_timestamp') . " > " . SQL::get_seconds_back( $secs ) . " 
					GROUP BY kev_key_id, hw_address HAVING count(kev_key_id) >= 3";
		
		return $this->db->query( $sql, $a )->result();
	}
	
	public function company_owns_keychain( $com_id, $key_uid )
	{
		return $this->db->get_var( 'SELECT 1 FROM keychain WHERE key_company = ? AND key_uid = ? LIMIT 1', array( $com_id, $key_uid ) );
	}
	
	public function company_owns_keychain_from_df( $com_df_id, $key_uid )
	{
		return $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT key_company FROM keychain WHERE key_uid = ? LIMIT 1 )', array( $com_df_id, $key_uid ) );
	}
	
	public function owns_keychain( $uid, $key_uid )
	{
		return $this->db->get_var( 'SELECT 1 FROM keychain WHERE key_uid = ? AND key_user = ? LIMIT 1', array( $key_uid, intval( $uid ) ) );
	}
	
	public function link( $key_uid, $uid )
	{
		$this->db->query( SQL::make_update_pdo( 'keychain', array( 'user', 'uid' ), 'uid', '', 'key_' ), array( $uid, $key_uid ) );
	}
	
	public function unlink( $key_uid )
	{
		$this->db->query( SQL::make_update_pdo( 'keychain', array( 'user', 'uid' ), 'uid', '', 'key_' ), array( 0, $key_uid ) );
	}
	
	public function get_from_user( $uid )
	{
		return $this->db->get_results( 'SELECT * FROM keychain WHERE key_user = ?', ARRAY_A, array( $uid ) );
	}

	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM keychain_events WHERE kev_key_company = ?', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM keychain WHERE key_company = ?', array( $com_id ) );
	}
}

