<?php
class HardwareSetupSignalHistory_model extends CI_Model
{
	public static $fields = array( 'company_code', 'receiver_code', 'hw_code', 'hw_serial', 'inst_time', 'first_timestamp', 'last_timestamp', 'signal', 'signal_filtered', 'signal_quality' );
	
	public function add( $company_code, $receiver_code, $hw_code, $hw_serial, $inst_time, $first_timestamp, $last_timestamp, $signal, $signal_filtered )
	{
		$values = array(
			$company_code, 
			$receiver_code, 
			$hw_code, 
			$hw_serial, 
			$inst_time, 
			$first_timestamp,
			$last_timestamp,
			$signal,
			$signal_filtered,
			round( 100 * (float)$signal_filtered / 127.0 )
		);
		
		$this->db->query( SQL::make_insert_pdo('hardware_setup_signal_history', self::$fields, '', 'hwsh_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function exists( $company_code, $receiver_code, $hw_code, $hw_serial, $first_received, $last_received )
	{
		$sql = "SELECT 1 FROM hardware_setup_signal_history 
				WHERE 
					hwsh_company_code = ? AND 
					hwsh_receiver_code = ? AND 
					hwsh_hw_code = ? AND 
					hwsh_hw_serial = ? AND 
					hwsh_first_timestamp = ? AND
					hwsh_last_timestamp = ?";
		
		$data = array( $company_code, $receiver_code, $hw_code, $hw_serial, $first_received, $last_received );
		
		return $this->db->get_var( $sql, $data );
	}
	
	public function get_last( $company_code, $receiver_code, $hw_code )
	{
		$sql = "SELECT * FROM hardware_setup_signal_history 
				WHERE 
					hwsh_company_code = ? AND 
					hwsh_receiver_code = ? AND 
					hwsh_hw_code = ?
				ORDER BY hwsh_inst_time DESC NULLS LAST
				LIMIT 1";
		
		$data = array( $company_code, $receiver_code, $hw_code );
		
		return $this->db->get_row( $sql, ARRAY_A, $data );
	}
	
	public function get_from_serial( $hw_serial )
	{
		return $this->db->get_results( "SELECT * FROM hardware_setup_signal_history WHERE hwsh_hw_serial = ? ORDER BY hwsh_inst_time DESC NULLS LAST", ARRAY_A, array( $hw_serial ) );
	}
	
	public function get_from_code( $company_code, $receiver_code, $hw_code )
	{
		$sql = "SELECT * FROM hardware_setup_signal_history 
				WHERE 
					hwsh_company_code = ? AND 
					hwsh_receiver_code = ? AND 
					hwsh_hw_code = ?
				ORDER BY hwsh_inst_time DESC NULLS LAST";
		
		$data = array( $company_code, $receiver_code, $hw_code );
		
		return $this->db->get_results( $sql, ARRAY_A, $data );
	}
	
	public function get( $company_code, $receiver_code, $hw_code )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_setup_signal_history WHRE hwsh_company_code = ? AND hwsh_receiver_code = ? AND hwsh_hw_code = ? ORDER BY hwsh_inst_time ASC' );
	}
	
	public function get_from_id( $hw_id )
	{
		return $this->db->get_results( 'SELECT hardware_setup_signal_history.* FROM hardware_setup_signal_history 
									INNER JOIN hardware ON hw_df_company = hwsh_company_code AND hw_df_receiver = hwsh_receiver_code AND hw_code = hwsh_hw_code 
									WHERE hw_id = ? ORDER BY hwsh_inst_time DESC NULLS LAST', ARRAY_A, array( $hw_id ) );
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hw_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'hardware_setup_signal_history.*, hardware.hw_id' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM hardware_setup_signal_history 
				LEFT JOIN hardware ON hw_df_company = hwsh_company_code AND hw_df_receiver = hwsh_receiver_code AND hw_code = hwsh_hw_code AND hw_serial = hwsh_hw_serial
				' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(hardware_setup_signal_history.*)' );
	}
	
	public function get_last_id( $filter_company = NULL )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		$sql = "SELECT hwsh_id FROM hardware_setup_signal_history 
				INNER JOIN company ON hwsh_company_code = com_df_id AND hwsh_receiver_code = com_rec_id 
				$where 
				ORDER BY hwsh_id DESC
				LIMIT 1";
		
		return $this->db->get_var( $sql );
	}
	
	public function get_all_current( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'hardware_setup_signal_history.*' )
	{
		$where		= self::get_company_filter( $filter_company, 'com_id' );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM hardware_setup_signal_history 
				INNER JOIN company ON com_df_id = hwsh_company_code AND com_rec_id = hwsh_receiver_code
				LEFT JOIN hardware ON hw_df_company = hwsh_company_code AND hw_df_receiver = hwsh_receiver_code AND hw_code = hwsh_hw_code AND hw_serial = hwsh_hw_serial
				' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function count_current( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(hardware_setup_signal_history.*)' );
	}
}
