<?php

class HardwarePreLink_model extends CI_Model
{
	public function exists( $hw_serial )
	{
		return $this->db->get_var( 'SELECT 1 FROM hardware_pre_link WHERE hwpl_hw_serial = ?', array( $hw_serial ) );
	}
	
	public function add( $hw_serial, $user )
	{
		if ( !$this->exists( $hw_serial ) )
		{
			$this->db->query( SQL::make_insert_pdo( 'hardware_pre_link', array( 'hw_serial', 'user' ), '', 'hwpl_' ), array( $hw_serial, $user ) );
			
			return $this->db->last_insert_id();
		}
		else
		{
			return FALSE;
		}
	}
	
	public function clear( $user )
	{
		$this->db->query( 'DELETE FROM hardware_pre_link WHERE hwpl_user = ?', array( $user ) );
	}
	
	public function clear_mac( $hw_serial )
	{
		$this->db->query( 'DELETE FROM hardware_pre_link WHERE hwpl_hw_serial = ?', array( $hw_serial ) );
	}
	
	public function get_from_user( $user )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_pre_link WHERE hwpl_user = ? ORDER BY hwpl_id ASC', ARRAY_A, array( $user ) );
	}
	
	public function get_from_mac( $hw_serial )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_pre_link WHERE hwpl_hw_serial = ? ORDER BY hwpl_id ASC', ARRAY_A, array( $hw_serial ) );
	}
} 
