<?php

class HardwareNoiseConfig_model extends CI_Model
{
	public static $fields = array(	'com_id', 'hw_serial', 'retry_count', 
									'period', 'noise_test_per_channel_count', 'signal_strength_test_count',
									'channels_to_test', 'batch_id', 'timestamp', 'lifetime', 'state', 'sent' );

	public function get_last_batch_id( $com_id = null )
	{
		if ( null == $com_id )
		{
			return intval( $this->db->get_var( "SELECT COALESCE(MAX(hwnc_batch_id),0) AS max_id FROM hardware_noise_config" ) );
		}
		
		return intval( $this->db->get_var( "SELECT COALESCE(hwnc_batch_id),0) AS max_id  FROM hardware_noise_config  WHERE hwnc_com_id = ?", array( $com_id ) ) );
	}
	
	public function get_next_batch_id()
	{
		return $this->get_last_batch_id() + 1;
	}
	
	public function add( $com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, $signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, $state )
	{
		$this->db->set_qd( array(	$com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, 
									$signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, 99000, $state, 0
		) );
		
		$this->db->query( SQL::make_insert_pdo( 'hardware_noise_config', self::$fields, '', 'hwnc_' ) );
	}
	
	public function update( $hwnc_id, $com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, $signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, $state )
	{
		$fields = self::$fields;
		
		array_push( $fields, 'id' );
		
		$this->db->set_qd( array(	$com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, 
									$signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, 99000, $state, 0, $hwnc_id
		) );
		
		$this->db->query( SQL::make_update_pdo( 'hardware_noise_config', $fields, 'id', '', 'hwnc_' ) );
	}
	
	public function set_state( $hwnc_id, $state )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware_noise_config', array( 'state', 'id' ), 'id', '', 'hwnc_' ), array( $state, $hwnc_id ) );
	}
	
	public function set_paused( $hwnc_id )
	{
		$this->set_state( $hwnc_id, 'PAUSED' );
	}
	
	public function set_activated( $hwnc_id )
	{
		$this->set_state( $hwnc_id, 'ACTIVE' );
	}
	
	public function set_erased( $hwnc_id )
	{
		$this->set_state( $hwnc_id, 'ERASED' );
	}
	
	public function exists( $com_id, $hw_serial )
	{
		return $this->db->get_var( 'SELECT hwnc_id FROM hardware_noise_config WHERE hwnc_com_id = ? AND hwnc_hw_serial = ?', array( $com_id, $hw_serial ) );
	}
	
	public function add_update( $com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, $signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, $state )
	{
		if ( $hwnc_id = $this->exists( $com_id, $hw_serial ) )
		{
			$this->update( $hwnc_id, $com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, $signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, $state );
		}
		else
		{
			$this->add( $com_id, $hw_serial, $retry_count, $period, $noise_test_per_channel_count, $signal_strength_test_count, $channels_to_test, $batch_id, $timestamp, $state );
		}
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hwnc_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$filter['filter'] = "hwnc_state != 'ERASED'";
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM hardware_noise_config ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function pending_send( $com_id )
	{
		return $this->db->get_var( 'SELECT COUNT(*) AS count FROM hardware_noise_config WHERE hwnc_sent = 0 AND hwnc_com_id = ?', array( $com_id ) );
	}
	
	public function get_pending_send( $com_id )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_noise_config WHERE hwnc_sent = 0 AND hwnc_com_id = ?', ARRAY_A, array( $com_id ) );
	}
	
	public function set_all_sent( $com_id )
	{
		$this->db->query( 'UPDATE hardware_noise_config SET hwnc_sent = 1 WHERE hwnc_com_id = ?', array( $com_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware_noise_config WHERE hwnc_com_id = ?', array( $com_id ) );
	}
}

