<?php
class HardwareHours_model extends CI_Model
{	
	public function get( $hw_id )
	{
		$this->db->set_qd( array( $hw_id ) );
		
		return $this->db->get_results( 'SELECT * FROM hardware_hours WHERE hh_hw_id = ?' );
	}
	
	public function delete( $hw_id )
	{
		return $this->db->query( 'DELETE FROM hardware_hours WHERE hh_hw_id = ?', array( $hw_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware_hours WHERE hh_hw_id IN ( SELECT hw_id FROM hardware WHERE hw_company = ? )', array( $com_id ) );
	}
	
	public function add( $hw_id, $day, $hour_init, $hour_end )
	{
		$fields = array( 'hw_id', 'day', 'init', 'end' );
		$values = array( $hw_id, $day, $hour_init, $hour_end );
		
		return $this->db->query( SQL::make_insert_pdo( 'hardware_hours', $fields, '', 'hh_' ), $values );
	}
	
	public function save( $hw_id, $form )
	{
		load_helper('hours');
		
		$this->db->trans_start();
		
		$this->delete( $hw_id );
		
		foreach( HoursSlot::$DAYS as $day=>$day_n )
		{
			foreach( HoursSlot::$TURNS as $turn=>$turn_n )
			{
				$ini = sprintf("hours_%s_%s_%s", $turn, $day, 'ini');
				$fin = sprintf("hours_%s_%s_%s", $turn, $day, 'fin');
				
				$hour_init	= $form[$ini];
				$hour_end	= $form[$fin];
				$start		= strtotime('1970-1-1 ' . $hour_init);
				$end		= strtotime('1970-1-1 ' . $hour_end);
				
				if ( $turn == 'noc' && $hour_end == '00:00' )
				{
					$end		= strtotime('1970-1-2 ' . $hour_end);
				}

				if ( '' != $hour_init && '' != $hour_end && $end > $start )
				{
					$this->add( $hw_id, $day, $hour_init, $hour_end );
				}
			}
		}
		
		$this->db->trans_complete();
	}
}
