<?php
class HardwareGroup_model extends CI_Model
{
	public function get( $group )
	{
		return $this->get_row( 'SELECT * FROM hardware_group WHERE hwg_id = ?', ARRAY_A, array( $group ) );
	}
	
	public function add( $name, $com_id )
	{
		$this->db->query( 'INSERT INTO hardware_group ( hwg_name, hwg_company ) VALUES ( ?, ? )', array( $name, $com_id ) );
		
		return $this->db->insert_id();
	}
	
	public function add_with_serial( $name, $com_id, $serial )
	{
		$this->db->query( 'INSERT INTO hardware_group ( hwg_name, hwg_company, hwg_serial ) VALUES ( ?, ?, ? )', array( $name, $com_id, $serial ) );
		
		return $this->db->insert_id();
	}
	
	public function update( $name, $group )
	{
		$this->db->query( 'UPDATE hardware_group SET hwg_name = ? WHERE hwg_id = ?', array( $name, $group ) );
	}
	
	public function delete( $group )
	{
		$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_group = ?', array( $group ) );
		$this->db->query( 'DELETE FROM hardware_group WHERE hwg_id = ?', array( $group ) );
	}
	
	protected function filter_company( $filter_company )
	{
		$where = SQL::get_or_filter( $filter_company, 'hwg_company' );
		
		if ( '' != $where )
		{
			$where = 'WHERE ' . $where;
		}
		
		return $where;
	}
	
	public function get_by_serial( $serial, $com_id = NULL )
	{
		if ( NULL != $com_id )
		{
			return $this->db->get_var( 'SELECT hwg_id FROM hardware_group WHERE hwg_serial = ? AND hwg_company = ? LIMIT 1', array( $serial, $com_id ) );
		}
		
		return $this->db->get_var( 'SELECT hwg_id FROM hardware_group WHERE hwg_serial = ? LIMIT 1', array( $serial ) );
	}
	
	public function get_name( $group )
	{
		return $this->db->get_var( 'SELECT hwg_name FROM hardware_group WHERE hwg_id = ? LIMIT 1', array( $group ) );
	}
	
	public function count( $filter_company = NULL )
	{
		return $this->db->get_var( 'SELECT COUNT(hwg_id) AS count FROM hardware_group ' . $this->filter_company( $filter_company ) );
	}
	
	public function get_all( $filter_company = NULL, $output = ARRAY_A  )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_group ' . $this->filter_company( $filter_company ) . ' ORDER BY hwg_name ASC', $output );
	}
	
	public function get_all_names( $filter_company = NULL, $output = OBJECT )
	{
		return $this->db->get_results( 'SELECT hwg_id AS id, hwg_name AS name FROM hardware_group ' . $this->filter_company( $filter_company ) . ' ORDER BY hwg_name ASC', $output );
	}
	
	public function get_group_links( $group )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_group_link INNER JOIN hardware_group ON hwgl_group = hwg_id INNER JOIN hardware ON hwgl_hw_id = hw_id 
										WHERE hwg_id = ? ORDER BY hwg_name ASC', ARRAY_A, array( $group ) );
	}
	
	public function get_all_links( $filter_company = NULL )
	{
		return $this->db->get_results( 'SELECT * FROM hardware_group_link INNER JOIN hardware_group ON hwgl_group = hwg_id INNER JOIN hardware ON hwgl_hw_id = hw_id ' . 
										$this->filter_company( $filter_company ) . ' ORDER BY hwg_name ASC', ARRAY_A );
	}
	
	public function company_owns_group( $com_id, $group )
	{
		return $this->db->get_var( 'SELECT 1 FROM hardware_group WHERE hwg_company = ? AND hwg_id = ? LIMIT 1', array( $com_id, $group ) );
	}

	public function company_owns_group_from_df( $com_df_id, $group )
	{
		return $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT hwg_company FROM hardware_group WHERE hwg_id = ? LIMIT 1 )', array( $com_df_id, $group ) );
	}
	
	public function is_linked( $group, $hw_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM hardware_group_link WHERE hwgl_hw_id = ? AND hwgl_group = ? LIMIT 1', array( $hw_id, $group ) );
	}
	
	public function link( $group, $hw_id )
	{
		if ( !$this->is_linked( $group, $hw_id ) )
		{
			$this->db->query( 'INSERT INTO hardware_group_link ( hwgl_hw_id, hwgl_group ) VALUES ( ?, ? )', array( $hw_id, $group ) );
			
			return TRUE;
		}
		
		return FALSE;
	}
	
	public function unlink( $group, $hw_id )
	{
		$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_hw_id = ? AND hwgl_group = ?', array( $hw_id, $group ) );
	}
	
	public function unlink_from_cores( $hw_id )
	{
		$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_hw_id = ? AND hwgl_group IN ( SELECT hwgl_group FROM hardware_group_link INNER JOIN hardware_group ON hwgl_group = hwg_id WHERE hwg_serial != 0 AND hwgl_hw_id = ? )', array( $hw_id, $hw_id ) );
	}
	
	public function unlink_all_from_group( $group )
	{
		$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_group = ?', array( $group ) );
	}
	
	public function exists_group_with_icon( $com_id, $icon )
	{
		return $this->db->get_var( 'SELECT hwg_id FROM hardware_group WHERE hwg_company = ? AND hwg_name = ? LIMIT 1', array( $com_id, get_icon_name( $icon ) ) );
	}
	
	public function get_groups_from_hw( $hw_id, $output = ARRAY_A )
	{
		return $this->db->get_results( 'SELECT hwg_id AS id, hwg_name AS name FROM hardware_group_link INNER JOIN hardware_group ON hwgl_group = hwg_id WHERE hwgl_hw_id = ?', $output, array( $hw_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_group IN ( SELECT hwg_id FROM hardware_group WHERE hwg_company = ? )', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM hardware_group WHERE hwg_company = ?', array( $com_id ) );
	}
}
