<?php

class HardwareGenericMessage_model extends CI_Model
{
	public static $table = 'hardware_generic_message';
	public static $prefix = 'hgm_';
	public static $fields = array( 'com_id', 'timestamp', 'serial', 'msg', 'state' );
	
	public function add( $com_id, $serial, $msg )
	{
		$values = array( $com_id, time(), $serial, $msg, 'PENDING_SEND' );
		
		$this->db->query( SQL::make_insert_pdo( self::$table, self::$fields, '', self::$prefix ), $values );
	
		return $this->db->insert_id();
	}
	
	public function get_pending( $com_id )
	{
		return $this->db->get_results( 'SELECT * FROM ' . self::$table . ' WHERE ' . self::$prefix . 'com_id = ? AND ' . self::$prefix . 'state = ? ORDER BY ' . self::$prefix . 'timestamp ASC', ARRAY_A, array( $com_id, 'PENDING_SEND' ) );
	}
	
	public function set_send_from_company( $com_id )
	{
		$this->db->query( 'UPDATE ' . self::$table . ' SET ' . self::$prefix . "state = 'OK' WHERE " . self::$prefix . 'com_id = ?', array( $com_id ) );
	}
	
	public function set_send( $hwd_id )
	{
		$this->db->query( 'UPDATE ' . self::$table . ' SET ' . self::$prefix . "state = 'OK' WHERE " . self::$prefix . 'id = ?', array( $hwd_id ) );
	}
} 
