<?php
class HardwareFake_model extends CI_Model
{
	public function delete( $id )
	{
		$this->db->query( 'DELETE FROM hardware_fake WHERE hwf_id = ?', array( $id ) );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM hardware_fake INNER JOIN locations ON hwf_city = loc_id ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hwf_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}

	function update( $form )
	{
		$fields = array( 'code', 'name', 'address', 'lat', 'long', 'icon', 'type' );
		$values = array( hexdec( $form['code'] ), $form['name'], $form['address'], floatval( $form['lat'] ), floatval( $form['long'] ), $form['icon'], intval( $form['type'] ) );
		
		$fields[] = 'id';
		$values[] = intval( $form['hwf_id'] );
		
		$this->db->set_qd( $values );

		$this->db->query( SQL::make_update_pdo( 'hardware_fake', $fields, 'id', '', 'hwf_' ) );
	}
	
	function add( $form )
	{
		$fields = array( 'code', 'name', 'address', 'lat', 'long', 'icon', 'type', 'company', 'city' );
		$values = array( hexdec( $form['code'] ), $form['name'], $form['address'], floatval( $form['lat'] ), floatval( $form['long'] ), $form['icon'], intval( $form['type'] ), $form['company'], $form['city'] );
		
		$this->db->set_qd( $values );
		
		$this->db->query( SQL::make_insert_pdo( 'hardware_fake', $fields, '', 'hwf_' ) );
		
		return $this->db->last_insert_id();
	}
	
	function code_count( $code, $com_id )
	{
		$this->db->set_qd( array( hexdec( $code ), $com_id ) );
		
		return $this->db->get_var( 'SELECT COUNT(*) as count FROM hardware_fake WHERE hwf_code = ? AND hwf_company = ?' );
	}
		
	function get_id_from_code( $code, $com_id )
	{
		$this->db->set_qd( array( hexdec( $code ), $com_id ) );
		
		return $this->db->get_var( 'SELECT hwf_id FROM hardware_fake WHERE hwf_code = ? AND hwf_company = ?' );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware_fake WHERE hwf_company = ?', array( $com_id ) );
	}
}

