<?php

require_once( LIBSPATH . 'hardwareevents.php' );

class HardwareEvents_model extends CI_Model
{
	public function parse_frame( &$frame, $user, $tprefix = 'df' )
	{
		$frame_data = FrameUtils::parse_framedata($frame[$tprefix . '_frame_data'], FrameUtils::$TPL_FRAME_INCOMING);
		
		$emergency	= FALSE;
		$done		= FALSE;
		$desc		= $this->get_event_desc( $frame['hw_id'], $frame['hw_company'], $frame[$tprefix . '_msg_type'], $frame_data, $emergency );
		$resolved	= TRUE;
		
		if ( isset( $frame['dse_status'] ) && '' != $frame['dse_status'] )
		{
			$done	= TRUE;
		}
		
		if(!$desc)
		{
			$resolved = FALSE;
			
			$desc = 't:'.dechex($frame[$tprefix . '_msg_type']).
					' ca:'.dechex($frame_data['evt_qualifier']).
					' ce:'.dechex($frame_data['evt_code']).
					' cp:'.dechex($frame_data['partition']).
					' z:'.dechex($frame_data['zone']);
		}

		if ( $user->get_type() >= USER_TYPE_CPNY_RO )
		{
			$event = array(
				'id' => $frame[$tprefix . '_id'],
				'user' => isset( $frame['ui_fullname'] ) ? $frame['ui_fullname'] : 'NO ASIGNADO',
				'hw_id' => isset( $frame['hw_id'] ) ? $frame['hw_id'] : NULL,
				'hw_serial' => dechex( $frame['hw_serial'] ),
				'hw_code' => dechex( $frame['hw_code'] ),
				'target' => $frame['hw_name'],
				'time' => strftime ('%a %d/%b/%y - %H:%M:%S',$frame[$tprefix . '_hw_timestamp']),
				'desc' => $desc,
				'emergency' => $emergency,
				'resolved' => $resolved,
				'done' => $done,
				'dse_id' => isset( $frame['dse_id'] ) ? $frame['dse_id'] : NULL
			);
		}
		else
		{
			$event = array(
				'id' => $frame[$tprefix . '_id'],
				'hw_id' => isset( $frame['hw_id'] ) ? $frame['hw_id'] : NULL,
				'target' => $frame['hw_name'],
				'time' => strftime ('%a %d/%b/%y - %H:%M:%S',$frame[$tprefix . '_hw_timestamp']),
				'desc' => $desc,
				'emergency' => $emergency,
				'resolved' => $resolved,
				'done' => $done,
				'dse_id' => isset( $frame['dse_id'] ) ? $frame['dse_id'] : NULL
			);
		}
		
		return $event;
	}
	
	/** could be an array of companies or just a com_id */
	public static function get_company_filter( $filter_company = NULL, $field_name = 'com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function get_latests_dshield_events( $filter_company, $user, $since_id = NULL, $hw_id = NULL, $num_events = 100 )
	{
		$data	= array( $num_events );
		$where	= self::get_company_filter( $filter_company );
		
		if ( '' != $where )
		{
			$where = ' AND ' . $where;
		}
		
		if ( NULL != $since_id )
		{
			array_unshift( $data, $since_id );
			
			$where = $where . ' AND df_id > ? ';
		}
		
		if ( NULL != $hw_id )
		{
			array_unshift( $data, $hw_id );
			
			$where .= ' AND hw_id = ? ';
		}
		
		$sql = 'SELECT df_id, df_msg_type, df_frame_data, df_hw_timestamp, hw_serial, hw_code, hw_id, hw_company, hw_name, dse_id, dse_status 
				FROM data_frames
				INNER JOIN hardware ON hw_code = df_hw_code AND hw_df_company = df_company_code AND hw_df_receiver = df_receiver_code
				INNER JOIN company ON com_df_id = df_company_code AND com_rec_id = df_receiver_code 
				LEFT JOIN users_info ON ui_id = hw_user
				LEFT JOIN dshield_event_relation ON der_event_id = df_id 
				LEFT JOIN dshield_event ON dse_event_id = df_id OR dse_id = der_dse_id
				WHERE
					df_packet_type = 1  
					' . $where . ' 
				ORDER BY df_id DESC
				LIMIT ?';
		
		$frames = $this->db->get_results( $sql, ARRAY_A, $data );
		
		$events = NULL;
		
		if ( isset( $frames ) )
		{
			$events = array();
			
			foreach ( $frames as $frame )
			{
				$events[] = $this->parse_frame( $frame, $user );
			}
		}
		
		return $events;
	}
	
	function get( $event_id )
	{
		$sql = 'SELECT df_id, df_msg_type, df_frame_data, df_hw_timestamp, hw_serial, hw_code, hw_id, hw_company, hw_name
				FROM data_frames
				INNER JOIN hardware ON hw_code = df_hw_code AND hw_df_company = df_company_code AND hw_df_receiver = df_receiver_code
				INNER JOIN company ON com_df_id = df_company_code AND com_rec_id = df_receiver_code 
				LEFT JOIN users_info ON ui_id = hw_user
				WHERE df_id = ?
				LIMIT 1';
		
		return $this->db->get_row( $sql, ARRAY_A, array( $event_id ) );
	}
	
	function get_frames( $from_t, $to_t, $query = '', $tname = 'data_frames', $tprefix = 'df', $limit = 2000 )
	{
		$sql = 'SELECT ' . $tprefix . '_id, ' . $tprefix . '_msg_type, ' . $tprefix . '_frame_data, ' . $tprefix . '_hw_timestamp, hw_serial, hw_code, hw_id, hw_company, hw_name, ui_uid, CONCAT( ui_lastname, \' \', ui_name ) AS ui_fullname
				FROM ' . $tname . ' 
				INNER JOIN hardware ON hw_code = ' . $tprefix . '_hw_code AND hw_df_company = ' . $tprefix . '_company_code AND hw_df_receiver = ' . $tprefix . '_receiver_code 
				LEFT JOIN users_info ON ui_id = hw_user 
				WHERE 
				' . $tprefix . '_packet_type = 1 '. $query . ' AND ' . $tprefix . '_hw_timestamp > '.$from_t.' AND ' . $tprefix . '_hw_timestamp < '.$to_t.' 
				ORDER BY ' . $tprefix . '_hw_timestamp DESC 
				LIMIT ' . $limit;

		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	function get_lastest_events( $hw_id, $num_events = 3 )
	{
		$this->db->set_qd( array( $hw_id, $num_events ) );

		$sql = 'SELECT df_id, df_msg_type, df_frame_data, df_hw_timestamp, hw_serial, hw_code, hw_id, hw_company, hw_name
					FROM data_frames
					INNER JOIN hardware ON hw_code = df_hw_code AND hw_df_company = df_company_code AND hw_df_receiver = df_receiver_code
					LEFT JOIN users_info ON ui_id = hw_user
					WHERE
						df_packet_type = 1 AND
						hw_id = ?
					ORDER BY df_hw_timestamp DESC
					LIMIT ?';

		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_event_desc($hw_id, $hw_company, $msg_type, $frame_data, &$emergency)
	{
		/** get_event_description( _hw_id BIGINT, _hw_company BIGINT, _msg_type INT, _evt_qualifier INT, _evt_code INT, _partition INT, _zone INT ) */
		$event_info = json_decode( $this->db->get_var( 'SELECT get_event_description( 
														' . intval( $hw_id ) . ', ' . 
															intval( $hw_company ) . ', ' . 
															$msg_type . ', ' .
															$frame_data['evt_qualifier'] . ', ' . 
															$frame_data['evt_code'] . ', ' . 
															$frame_data['partition'] . ', ' . 
															$frame_data['zone'] . 
							' )' ) );
		
		$emergency = isset( $event_info->emergency ) && 0 != $event_info->emergency;
		
		return isset( $event_info->txt ) ? $event_info->txt : '';
	}
}
