<?php
require_once('configcommand_model.php');

class HardwareConfigCommand_model extends ConfigCommand_model
{
	public static $fields = array( 'timestamp', 'serial', 'state_type', 'mode', 'cmd', 'data_count', 'frame_data', 'state', 'batch_id', 'retry_count', 'force', 'lifetime' );
	
	function __construct()
	{
		parent::__construct( 'hardware_config_command', 'hwcc_' );
	}
	
	public function add( $hw_serial, $timestamp, $state_type, $mode, $cmd, $data_count, $frame_data, $state, $batch_id, $retry_count = 1, $force_send = 0, $lifetime = 99000 )
	{
		$this->db->set_qd( array( $timestamp, $hw_serial, $state_type, $mode, $cmd, $data_count, $frame_data, $state, $batch_id, $retry_count, $force_send, $lifetime ) );
		
		$this->db->query( SQL::make_insert_pdo( 'hardware_config_command', self::$fields, '', 'hwcc_' ) );
	}
	
	public function edit( $hwcc_id, $hw_serial, $timestamp, $state_type, $mode, $cmd, $data_count, $frame_data, $state )
	{
		$fields = array_splice( self::$fields, 0, count( $fields ) - 2 );
		
		array_push( $fields, $hwcc_id );
		
		$this->db->set_qd( array( $timestamp, $hw_serial, $state_type, $mode, $cmd, $data_count, $frame_data, $state, $hwcc_id ) );
		
		$this->db->query( SQL::make_update_pdo( 'hardware_config_command', $fields, 'id', '', 'hwcc_' ) );
	}
	
	public function exists( $hw_serial, $cmd )
	{
		return $this->db->get_var( "SELECT hwcc_id, MAX(hwcc_timestamp) 
									FROM hardware_config_command 
									WHERE hwcc_serial = ? AND hwcc_cmd = ? AND hwcc_state = 'WAITING_RESPONSE' GROUP BY hwcc_id LIMIT 1 OFFSET 0", 
									array( $hw_serial, $cmd ) );
	}
	
	public function get_last_company_batch_id( $com_id )
	{
		$batch_id = $this->db->get_var( 'SELECT COALESCE(cac_batch_id,0) FROM company_airmesh_config WHERE cac_com_id = ? LIMIT 1', array( $com_id ) );
		
		return isset( $batch_id ) ? $batch_id : 0;
	}
}
