<?php
require_once('configcommand_model.php');

class HardwareCityMeshCommand_model extends ConfigCommand_model
{
	public static $fields = array( 'timestamp', 'serial', 'code', 'msg_type', 'mode', 'cmd', 'val', 'msg_type_val', 'force', 'checksum', 'state', 'batch_id', 'retry_count', 'lifetime', 'priority' );
	
	function __construct()
	{
		parent::__construct( 'hardware_citymesh_command', 'hwcc_' );
	}
	
	public function add( $hw_serial, $timestamp, $code, $msg_type, $mode, $cmd, $val, $msg_type_val, $force, $checksum, $state, $batch_id, $retry_count = 1, $lifetime = 99000, $priority = 0 )
	{
		$this->db->set_qd( array( $timestamp, $hw_serial, $code, $msg_type, $mode, $cmd, $val, $msg_type_val, $force, $checksum, $state, $batch_id, $retry_count, $lifetime, $priority ) );
		
		$this->db->query( SQL::make_insert_pdo( 'hardware_citymesh_command', self::$fields, '', 'hwcc_' ) );
	}
	
	public function edit( $hwcc_id, $hw_serial, $timestamp, $code, $msg_type, $mode, $cmd, $val, $msg_type_val, $force, $checksum, $state )
	{
		$fields = array_splice( self::$fields, 0, count( $fields ) - 2 );
		
		array_push( $fields, $hwcc_id );
		
		$this->db->set_qd( array( $timestamp, $hw_serial, $code, $msg_type, $mode, $cmd, $val, $msg_type_val, $force, $checksum, $state, $hwcc_id ) );
		
		$this->db->query( SQL::make_update_pdo( 'hardware_citymesh_command', $fields, 'id', '', 'hwcc_' ) );
	}
	
	public function exists( $hw_serial, $msg_type, $cmd )
	{
		return $this->db->get_var( "SELECT hwcc_id, MAX(hwcc_timestamp) 
									FROM hardware_citymesh_command 
									WHERE hwcc_serial = ? AND hwcc_msg_type = ? AND hwcc_cmd = ? AND hwcc_state = 'WAITING_RESPONSE' GROUP BY hwcc_id ORDER BY hwcc_id DESC LIMIT 1 OFFSET 0", 
									array( $hw_serial, $msg_type, $cmd ) );
	}
	
	public function exists_type( $hw_serial, $msg_type, $batch_id )
	{
		return $this->db->get_var( "SELECT hwcc_id, MIN(hwcc_timestamp) 
									FROM hardware_citymesh_command 
									WHERE hwcc_serial = ? AND hwcc_msg_type = ? AND hwcc_batch_id = ? AND hwcc_state = 'WAITING_RESPONSE' GROUP BY hwcc_id ORDER BY hwcc_id DESC LIMIT 1 OFFSET 0", 
									array( $hw_serial, $msg_type, $batch_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware_citymesh_command WHERE hwcc_serial IN ( SELECT hw_serial FROM hardware WHERE hw_company = ? )', array( $com_id ) );
	}
	
	public function get_last_company_batch_id( $com_id )
	{
		$batch_id = $this->db->get_var( 'SELECT COALESCE(ccc_batch_id,0) FROM company_citymesh_config WHERE ccc_com_id = ? LIMIT 1', array( $com_id ) );
		
		return isset( $batch_id ) ? $batch_id : 0;
	}
}
