<?php
class Hardware_model extends CI_Model
{
	public function get( $hw_id )
	{
		get_last_hour_times( $start, $end );
		
		$sql = 'SELECT hardware.*, tests_log.*, COALESCE(MAX(data_frames.df_hw_timestamp),NULL) AS df_hw_timestamp
									FROM hardware 
									LEFT JOIN tests_log ON tl_hw_id = hw_id AND tl_from_time > '.$start.' AND tl_from_time < '.$end .' ' . ' 
									LEFT JOIN data_frames ON df_hw_serial = hw_serial
									WHERE hw_id = ? 
									GROUP BY hw_id, tl_id';
		
		$hw = $this->db->get_row( $sql, ARRAY_A, array( $hw_id ) );
		
		$signal_filtered	= '-';
		
		if( $hw['hw_setup_signal_filtered'] != NULL )
		{
			$sn					= round( 100 * $hw['hw_setup_signal_filtered'] / $hw['hw_setup_signal_total_xbee'] );
			$signal_filtered	= min($sn,100).'%';
		}
		
		$hw['signal_filtered']= $signal_filtered;
		
		return $hw;
	}
	
	public function exists( $hw_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_id = ?', array( $hw_id ) );
	}
	
	public function get_from_id( $hw_id, $output = ARRAY_A )
	{
		return $this->db->get_row( 'SELECT * FROM hardware WHERE hw_id = ?', $output, array( $hw_id ) );
	}
	
	public function get_code( $hw_id )
	{
		return $this->db->get_var( 'SELECT hw_code FROM hardware WHERE hw_id = ?', array( $hw_id ) );
	}
	
	public function get_serial( $hw_id )
	{
		return $this->db->get_var( 'SELECT hw_serial FROM hardware WHERE hw_id = ?', array( $hw_id ) );
	}
	
	public function get_code_from_mac( $hw_serial )
	{
		return $this->db->get_var( 'SELECT hw_code FROM hardware WHERE hw_serial = ?', array( $hw_serial ) );
	}
	
	public function get_last_message( $hw_id )
	{
		return $this->db->get_var( 'SELECT hw_last_message FROM hardware WHERE hw_id = ?', array( $hw_id ) );
	}
	
	public function fix_broken_com_id( $com_id, $com_df_id, $com_rec_id )
	{
		return $this->db->query( 'UPDATE hardware SET hw_company = ? WHERE hw_company != ? AND hw_df_company = ? AND hw_df_receiver = ?', array( $com_id, $com_id, $com_df_id, $com_rec_id ) );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public static function get_count_sql( $filter_company = NULL )
	{
		$where = self::get_company_filter( $filter_company );
		
		if ( '' != $where )
		{
			$where = 'WHERE ' . $where;
		}
		
		return "SELECT COUNT(hw_id) AS count FROM hardware $where";
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		get_last_hour_times( $start, $end );
		
		$sql = 'SELECT ' . $fields_get . ' FROM hardware 
												LEFT JOIN users_info ON hw_user = ui_id 
												LEFT JOIN users ON ui_uid = uid
												LEFT JOIN tests_log ON tl_hw_id = hw_id AND tl_from_time > '.$start.' AND tl_from_time < '.$end .' ' . 
												$where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function get_from_serial( $hw_serial, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT hardware.*, COALESCE(users_info.ui_uid,0) AS hw_uid FROM hardware LEFT JOIN users_info ON hw_user = ui_id WHERE hw_serial = ?', $output, array( intval( $hw_serial ) ) );
	}

	public function update_icon( $hw_id, $icon )
	{
		$db = db_get();
		
		$db->set_qd( array( $icon, $hw_id ) );
		
		$db->query( SQL::make_update_pdo( 'hardware', array( 'icon', 'id' ), 'id', '', 'hw_' ) );
	}
	
	public function update_info( $hw_id, $info )
	{
		$db = db_get();
		
		$db->set_qd( array( $info, $hw_id ) );
		
		$db->query( SQL::make_update_pdo( 'hardware', array( 'info', 'id' ), 'id', '', 'hw_' ) );
	}
	
	public function update_core_from_serial( $hw_serial, $hw_core )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'core', 'serial' ), 'serial', '', 'hw_' ), array( $hw_core, $hw_serial ) );
	}
	
	public function delete( $hw_id )
	{
		$this->db->query( 'DELETE FROM hardware WHERE hw_id = ?', array( $hw_id ) );
		
		$hw = $this->get_from_id( $hw_id );
		
		if ( isset( $hw ) )
		{
			$this->db->query( 'DELETE FROM rfid_citymesh WHERE rc_code = ? AND rc_com_id = ?', array( $hw['hw_code'], $hw['hw_company'] ) );
		}
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM hardware WHERE hw_company = ?', array( $com_id ) );
	}
	
	public function get_company_macs( $com_id, $get_code = FALSE )
	{
		$db = db_get();
		
		$db->set_qd( array( intval( $com_id ) ) );
		
		$res = $db->get_results( 'SELECT to_hex(hw_serial) AS hw_serial ' . ( $get_code == TRUE ? ', to_hex(hw_code) AS hw_code' : '' ) .  ' FROM hardware WHERE hw_company = ? ORDER BY hw_serial ASC', ARRAY_A );
		
		if ( isset( $res ) && !empty( $res ) )
		{
			$macs = array();
			
			foreach ( $res as $row )
			{
				array_push( $macs,	( $get_code == TRUE ) ? array( $row['hw_serial'], $row['hw_code'] ) : $row['hw_serial'] );
			}
			
			return $macs;
		}
		
		return NULL;
	}
	
	public function get_company_macs_and_code( $com_id )
	{
		return self::get_company_macs( $com_id, TRUE );
	}
	
	public function get_company_macs_null_signal( $com_id )
	{
		require_once(CORE.'hw_stats.php');
		
		$db = db_get();
		
		HW_Stats::update_time();
		
		$query = HW_Stats::get_company_query(HW_Stats::$unix_time1, HW_Stats::$unix_time2, FrameUtils::$TESTS_LOG_TIMESPAN_SEC).HW_Stats::get_map_order_query();
		
		$db->set_qd(array($com_id));
		
		$res	= $db->get_results($query, ARRAY_A);
		
		if ( isset( $res ) && !empty( $res ) )
		{
			$macs	= array();
			
			$data	= HW_Stats::format_test_data($res, HW_Stats::$unix_time1, HW_Stats::$unix_time2);
			
			foreach ( $data as &$row ) {
				HW_Stats::create_real_count( $row, HW_Stats::$unix_time1, HW_Stats::$unix_time2 );
				
				if ( $row['thours'] > 2 )
				{
					$tests = round( $row['count'] / $row['thours'] );
				}
				else
				{
					$tests = $row['count'];
				}

				if ( !$tests || $tests <= 2 )
				{
					array_push( $macs, (string)dechex( $row['hw_serial'] ) );
				}
			}
			
			return $macs;
		}
		
		return NULL;
	}
	
	/** could be an array of companies or just a com_id */
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hw_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}

	public function hours_get_day( $hw_id, $day = 'today' )
	{
		$db = db_get();
		
		if ( $day == 'today' )
		{
			$day = day2str( date( 'w' ) );
		}
		
		$db->set_qd( array( $hw_id, $day ) );
		
		return $db->get_results( 'SELECT * FROM hardware_hours WHERE hh_hw_id = ? AND hh_day = ?' );
	}

	public function get_action_desc( $hw_id, $index )
	{
		$db = db_get();
		
		$db->set_qd( array( $hw_id,$index ) );
		$action_info = $db->get_var('SELECT hat_var FROM hardware_actions_tpl WHERE hat_hw_id = ? AND hat_code = ?');

		if(!$action_info)
		{
			$db->set_qd( array($hw_id) );
			$com_id = $db->get_var('SELECT hw_company FROM hardware WHERE hw_id = ?');
			if($com_id)
			{
				$db->set_qd( array( $com_id, $index ) );
				$action_info = $db->get_var('SELECT cat_var FROM company_actions_tpl WHERE cat_company_id = ? AND cat_code = ?');
			}
		}

		if(!$action_info)
		{
			$db->set_qd( array($index ) );
			$action_info = $db->get_var('SELECT at_var FROM actions_tpl WHERE at_code = ?');
		}

		return $action_info;
	}
	
	public function update( $form )
	{
		$db		= db_get();
		$fields = array( 'name', 'address', 'lat', 'long', 'state', 'icon' );
		$values = array( $form['name'], $form['address'], floatval( $form['lat'] ), floatval( $form['long'] ), $form['state'], $form['icon'] );
		
		if ( isset( $form['user_id'] ) && isset( $form['user_info_id'] ) )
		{
			if ( isset( $form['old_user_info_id'] ) )
			{
				if ( intval( $form['user_info_id'] ) != intval( $form['old_user_info_id'] ) )
				{
					$fields[] = 'user';
					$values[] = intval( $form['user_info_id'] );
				}
			}
			else
			{
				$fields[] = 'user';
				$values[] = intval( $form['user_info_id'] );
			}
		}
		
		$fields[] = 'id';
		$values[] = intval( $form['hw_id'] );
		
		$db->set_qd( $values );

		$db->query( SQL::make_update_pdo( 'hardware', $fields, 'id', '', 'hw_' ) );
	}
	
	public function update_pos( $hw_id, $lat, $long )
	{
		$db		= db_get();
		$fields = array( 'lat', 'long', 'id' );
		$values = array( floatval( $lat ), floatval( $long ), intval( $hw_id ) );
		
		$db->set_qd( $values );

		$db->query( SQL::make_update_pdo( 'hardware', $fields, 'id', '', 'hw_' ) );
	}

	function code_count( $code, $df_code, $df_rec )
	{
		$this->db->set_qd( array( hexdec( $code ), $df_code, $df_rec ) );
		
		return $this->db->get_var( 'SELECT COUNT(*) as count FROM hardware WHERE hw_code = ? AND hw_df_company = ? AND hw_df_receiver = ?' );
	}
	
	public function get_all_codes( $filter_company, $hw_code = NULL, $hw_user = NULL )
	{
		$where				= self::get_company_filter( $filter_company );
		$filter				= array();
		$filter['filter']	= NULL != $hw_code ? "to_hex(hw_code) ILIKE '%" . SQL::escape_string( $hw_code ) . "%'" : '';
		
		if ( NULL != $hw_user && intval( $hw_user ) > 0 )
		{
			$filter_hw_user = 'hw_user = ' . intval( $hw_user );
			
			$filter['filter'] .= '' != $filter['filter'] ? ' AND ' . $filter_hw_user : $filter_hw_user;
		}
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT hw_id, hw_company, to_hex(hw_code) AS hw_code FROM hardware $where", ARRAY_A );
	}
	
	public function get_all_names( $filter_company, $hw_name = NULL, $hw_user = NULL )
	{
		$where				= self::get_company_filter( $filter_company );
		$filter				= array();
		$filter['filter']	= NULL != $hw_name ? "hw_name ILIKE '%" . SQL::escape_string( $hw_name ) . "%'" : '';
		
		if ( NULL != $hw_user && intval( $hw_user ) > 0 )
		{
			$filter_hw_user = 'hw_user = ' . intval( $hw_user );
			
			$filter['filter'] .= '' != $filter['filter'] ? ' AND ' . $filter_hw_user : $filter_hw_user;
		}
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT hw_id, hw_company, hw_name FROM hardware $where", ARRAY_A );
	}
	
	public function get_all_serials( $filter_company, $hw_serial = NULL, $hw_user = NULL )
	{
		$where				= self::get_company_filter( $filter_company );
		$filter				= array();
		$filter['filter']	= NULL != $hw_serial ? "to_hex(hw_serial) ILIKE '%" . SQL::escape_string( $hw_serial ) . "%'" : '';
		
		if ( NULL != $hw_user && intval( $hw_user ) > 0 )
		{
			$filter_hw_user = 'hw_user = ' . intval( $hw_user );
			
			$filter['filter'] .= '' != $filter['filter'] ? ' AND ' . $filter_hw_user : $filter_hw_user;
		}
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT hw_id, hw_company, to_hex(hw_serial) AS hw_serial FROM hardware $where", ARRAY_A );
	}
	
	public function link( $hw_id, $ui_id )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'user', 'id' ), 'id', '', 'hw_' ), array( $ui_id, $hw_id ) );
	}
	
	public function unlink( $hw_id )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'user', 'id' ), 'id', '', 'hw_' ), array( 0, $hw_id ) );
	}

	public function get_with_icon( $filter_company, $icon )
	{
		$where				= self::get_company_filter( $filter_company );
		$filter				= array();
		$filter['filter']	= 'hw_icon = ?';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( 'SELECT hw_id FROM hardware ' . $where, ARRAY_A, array( $icon ) );
	}

	////
	// Functions for GPRS devices.

	public function update_gsm_config( $imei, $config )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'gsm_config', 'imei' ), 'imei', '', 'hw_' ), array( $config, $imei ) );
	}
	
	public function update_cmd_state( $imei, $state )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'cmd_state', 'imei' ), 'imei', '', 'hw_' ), array( $state, $imei ) );
	}

	public function update_cmd_timestamp( $imei, $timestamp )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'cmd_timestamp', 'imei' ), 'imei', '', 'hw_' ), array( $timestamp, $imei ) );
	}

	public function update_ip( $imei, $ip )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'ip', 'imei' ), 'imei', '', 'hw_' ), array( $ip, $imei ) );
	}
	
	public function update_port( $imei, $port )
	{
		$this->db->query( SQL::make_update_pdo( 'hardware', array( 'port', 'imei' ), 'imei', '', 'hw_' ), array( $port, $imei ) );
	}
	
	public function update_last_message( $serial, $time = NULL )
	{
		$time = NULL != $time ? $time : time();
		
		$this->db->query( 'UPDATE hardware SET hw_last_message = ? WHERE hw_serial = ?', array( $time, $serial ) );
	}
	
	public function update_is_kpanel( $serial, $is_panel )
	{
		$this->db->query( 'UPDATE hardware SET hw_is_kpanel = ? WHERE hw_serial = ?', array( $is_panel, $serial ) );
	}
	
	public function update_is_city7( $serial, $is_city7 = 1 )
	{
		$this->db->query( 'UPDATE hardware SET hw_is_city7 = ? WHERE hw_serial = ?', array( $is_city7, $serial ) );
	}
	
	public function get_ip_port( $imei )
	{
		return $this->db->get_row( 'SELECT hw_ip, hw_port FROM hardware WHERE hw_imei = ?', ARRAY_A, array( $imei ) );
	}

	public function get_from_imei( $hw_imei, $output = ARRAY_A )
	{
		return $this->db->get_row( 'SELECT * FROM hardware WHERE hw_imei = ?', $output, array( $hw_imei ) );
	}
	
	public function get_gsm_config( $imei, $decode = TRUE )
	{
		$this->load->library('citymeshgsm');
		
		$curcfg = $this->db->get_var( 'SELECT hw_gsm_config FROM hardware WHERE hw_imei = ?', array( $imei ) );
		
		if ( !isset( $curcfg ) )
		{
			$cfg = json_encode( $this->citymeshgsm->default_config() );
			
			$this->update_gsm_config( $imei, $cfg );
			
			return $decode ? $this->citymeshgsm->default_config() : $cfg;
		}
		
		return $decode ? json_decode( $curcfg, TRUE ) : $curcfg;
	}
		
	public function get_from_user( $ui_id )
	{
		return $this->db->get_results( 'SELECT * FROM hardware WHERE hw_user = ?', ARRAY_A, array( $ui_id ) );
	}
	
	public function get_lost_instalations()
	{
		return $this->db->get_results( 'SELECT * FROM hardware WHERE ( hw_setup_signal = 0 OR hw_setup_signal_filtered = 0 ) AND hw_inst_time > ' . SQL::get_31_days_back(), ARRAY_A );
	}
	
	public function get_instalation_by_month( $start_time = NULL, $end_time = NULL, $filter_company = NULL )
	{
		$filter = SQL::get_or_filter( $filter_company, 'hw_company' );
		$hw_inst_time_uts = SQL::unix_timestamp("date_trunc('month', hw_create_time)");
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ') ';
		}
		
		if ( NULL != $start_time && NULL != $end_time )
		{
			$filter = "AND $hw_inst_time_uts >= $start_time AND $hw_inst_time_uts < $end_time $filter ";
		}
		
		$sql = "SELECT *
				FROM
				(
					(
						SELECT
							hw_company, 
							date_trunc('month', hw_create_time) AS month_c, 
							$hw_inst_time_uts AS tlc_from_time,
							com_name,
							COUNT(hw_id) AS tlc_tests_count
						FROM hardware
						INNER JOIN company ON com_id = hw_company
						WHERE 
							date_trunc('month', hw_create_time) IS NOT NULL 
							$filter 
						GROUP BY hw_company, com_name, month_c, $hw_inst_time_uts 
						ORDER BY month_c ASC, hw_company ASC
					)
					UNION
					(
						SELECT
							0 AS hw_company, 
							date_trunc('month', hw_create_time) AS month_c,
							$hw_inst_time_uts AS tlc_from_time, 
							'Total' AS com_name,
							COUNT(hw_id) AS tlc_tests_count
						FROM hardware
						WHERE 
							date_trunc('month', hw_create_time) IS NOT NULL 
							$filter 
						GROUP BY month_c, $hw_inst_time_uts
						ORDER BY month_c ASC
					)
				) AS grouped
				ORDER BY month_c ASC, hw_company ASC";
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
}
