<?php
class GlobalEventType
{
	const DOMO			= 0;
	const DOMO_SIGNAL	= 1;
	const DKEEP			= 2;
	const GEOTRACE		= 3;
	const INFRACTION	= 4;
	const RFID			= 5;
	const REMOTE_CONTROL= 6;
	const ANY			= -1;
}

/** TABLE REFERENCE
 	ge_id SERIAL
	ge_type INT
	ge_event_id BIGINT
	ge_user_id BIGINT
	ge_hw_id BIGINT
	ge_hw_serial BIGINT
	ge_hw_code INT
	ge_com_id BIGINT
	ge_time BIGINT
	ge_desc CHARACTER VARYING(64)
	ge_emergency integer NOT NULL DEFAULT 0
 **/
class GlobalEvent_model extends CI_Model
{
	public function parse_frame( &$frame, $user )
	{
		$emergency	= FALSE;
		$done		= FALSE;
		$resolved	= TRUE;
		
		if ( isset( $frame['dse_status'] ) && '' != $frame['dse_status'] )
		{
			$done	= TRUE;
		}
		
		if ( $user->get_type() >= USER_TYPE_CPNY_RO )
		{
			$event = array(
				'id' => $frame['ge_id'],
				'user' => isset( $frame['ui_fullname'] ) ? $frame['ui_fullname'] : 'NO ASIGNADO',
				'hw_id' => isset( $frame['ge_hw_id'] ) ? $frame['ge_hw_id'] : NULL,
				'hw_serial' => dechex( $frame['ge_hw_serial'] ),
				'hw_code' => dechex( $frame['ge_hw_code'] ),
				'target' => isset( $frame['target'] ) ? $frame['target'] : '',
				'time' => strftime ('%a %d/%b/%y - %H:%M:%S',$frame['ge_time']),
				'desc' => $frame['ge_desc'],
				'reported_by' => isset( $frame['reported_by'] ) ? $frame['reported_by'] : '',
				'emergency' => 1 == $frame['ge_emergency'] ? TRUE : FALSE,
				'done' => $done,
				'dse_id' => isset( $frame['dse_id'] ) ? $frame['dse_id'] : NULL,
				'type' => $frame['ge_type']
			);
		}
		else
		{
			$event = array(
				'id' => $frame['ge_id'],
				'user' => isset( $frame['ui_fullname'] ) ? $frame['ui_fullname'] : 'NO ASIGNADO',
				'hw_id' => isset( $frame['ge_hw_id'] ) ? $frame['ge_hw_id'] : NULL,
				'target' => isset( $frame['target'] ) ? $frame['target'] : '',
				'time' => strftime ('%a %d/%b/%y - %H:%M:%S',$frame['ge_time']),
				'desc' => $frame['ge_desc'],
				'reported_by' => isset( $frame['reported_by'] ) ? $frame['reported_by'] : '',
				'emergency' => 1 == $frame['ge_emergency'] ? TRUE : FALSE,
				'done' => $done,
				'dse_id' => isset( $frame['dse_id'] ) ? $frame['dse_id'] : NULL,
				'type' => $frame['ge_type']
			);
		}
		
		return $event;
	}
	
	public function add( $type, $event_id, $user_id, $hw_id, $hw_serial, $hw_code, $com_id, $time, $desc, $emergency )
	{
		$fields = array( 'type', 'event_id', 'user_id', 'hw_id', 'hw_serial', 'hw_code', 'com_id', 'time', 'desc', 'emergency' );
		$values = array( $type, $event_id, $user_id, $hw_id, $hw_serial, $hw_code, $com_id, $time, $desc, $emergency );
		
		$this->db->query( SQL::make_insert_pdo( 'global_event', $fields, '', 'ge_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function update( $id, $type, $event_id, $user_id, $hw_id, $hw_serial, $hw_code, $com_id, $time, $desc, $emergency )
	{
		$fields = array( 'type', 'event_id', 'user_id', 'hw_id', 'hw_serial', 'hw_code', 'com_id', 'time', 'desc', 'emergency', $id );
		$values = array( $type, $event_id, $user_id, $hw_id, $hw_serial, $hw_code, $com_id, $time, $desc, $emergency, $id );
		
		$this->db->query( SQL::make_update_pdo( 'global_event', $fields, 'id', '', 'ge_' ), $values );
		
		return $id;
	}
	
	function get_events( $from_t, $to_t, $query = '', $type = GlobalEventType::DOMO, $order_by = 'ge_time DESC' )
	{
		$type_filter = $type != GlobalEventType::ANY ? "ge_type = {$type} " : "";
		
		if ( empty( $type_filter ) && str_starts_with( 'AND ', $query ) )
		{
			$query = substr( $query, 4 );
		}
		
		$sql = 'SELECT *, hw_name, CONCAT( ui_lastname, \' \', ui_name ) AS ui_fullname 
				FROM global_event
				INNER JOIN hardware ON hw_id = ge_hw_id
				LEFT JOIN users_info ON ui_id = hw_user
				WHERE ' . $type_filter . $query . ' AND ge_time > '.$from_t.' AND ge_time < '.$to_t.' 
				ORDER BY ' . $order_by . ' 
				LIMIT 2000';
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	function get_lastest_events( $hw_id, $num_events = 3 )
	{
		$this->db->set_qd( array( $hw_id, $num_events ) );

		$sql = 'SELECT global_event.*, ge_time as time, ge_desc as desc 
					FROM global_event
					INNER JOIN hardware ON hw_id = ge_hw_id
					LEFT JOIN users_info ON ui_id = hw_user
					WHERE ge_type = ' . GlobalEventType::DOMO . ' AND ge_hw_id = ?
					ORDER BY ge_time DESC
					LIMIT ?';
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	function get_lastest_geotrace_events( $imei, $num_events = 5 )
	{
		$this->db->set_qd( array( $imei, $num_events ) );

		$sql = 'SELECT global_event.*, ge_time as time, ge_desc as desc 
					FROM global_event
					INNER JOIN avl_hardware ON ahw_imei = ge_hw_id
					LEFT JOIN users_info ON ui_id = ahw_uid
					WHERE ge_type = ' . GlobalEventType::GEOTRACE . ' AND ge_hw_id = ?
					ORDER BY ge_time DESC
					LIMIT ?';
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_parsed_events( $filter_company, $user, $from_t, $to_t, $emergency = NULL )
	{
		$where	= self::get_company_filter( $filter_company );
		
		if ( '' != $where )
		{
			$where .= ' AND ';
		}
		
		$where .= 'ge_time > ' . $from_t . ' AND ge_time < ' . $to_t;
		
		$where .= ( '' != $where ? ' AND ' : '' ) . '( ge_type = ' . GlobalEventType::DOMO . ' OR ge_type = ' . GlobalEventType::DKEEP . ' ) ';
		
		$sql = 'SELECT global_event.*, COALESCE(hw.hw_name,key_owner_lastname || \' \' || key_owner_name) AS target, dse_id, dse_status, COALESCE(hw.hw_name,hwkc.hw_name) AS reported_by
				FROM global_event
				LEFT JOIN hardware AS hw ON hw.hw_id = ge_hw_id AND ge_type = ' . GlobalEventType::DOMO . '
				LEFT JOIN keychain ON key_id = ge_hw_id AND ge_type = ' . GlobalEventType::DKEEP . '
				LEFT JOIN hardware AS hwkc ON hwkc.hw_serial = ge_hw_serial AND ge_type = ' . GlobalEventType::DKEEP . '
				INNER JOIN company ON com_id = ge_com_id 
				LEFT JOIN users_info ON ui_id = hw.hw_user
				LEFT JOIN dshield_event_relation ON der_event_id = ge_id 
				LEFT JOIN dshield_event ON dse_event_id = ge_id OR dse_id = der_dse_id
				WHERE ' . $where . ' 
				ORDER BY ge_time DESC';
		
		$frames = $this->db->get_results( $sql, ARRAY_A );
		
		$events = NULL;
		
		if ( isset( $frames ) )
		{
			$events = array();
			
			foreach ( $frames as $frame )
			{
				$events[] = $this->parse_frame( $frame, $user );
			}
		}
		
		return $events;
	}
	
	public function get_latests_dshield_events( $filter_company, $user, $since_id = NULL, $hw_id = NULL, $num_events = 100 )
	{
		$data	= array( $num_events );
		$where	= self::get_company_filter( $filter_company );
		
		if ( '' != $where )
		{
			$where = ' AND ' . $where;
		}
		
		if ( NULL != $since_id )
		{
			array_unshift( $data, $since_id );
			
			$where = $where . ' AND ge_id > ? ';
		}
		
		if ( NULL != $hw_id )
		{
			array_unshift( $data, $hw_id );
			
			$where .= ' AND hw.hw_id = ? ';
		}
		
		if ( str_starts_with( 'AND ', $where ) )
		{
			$where = substr( $where, 4 );
		}
		
		$where .= ( '' != $where ? ' AND ' : '' ) . '( ge_type = ' . GlobalEventType::DOMO . ' OR ge_type = ' . GlobalEventType::DKEEP . ' ) ';
		
		$sql = 'SELECT global_event.*, COALESCE(hw.hw_name,key_owner_lastname || \' \' || key_owner_name) AS target, dse_id, dse_status, COALESCE(hw.hw_name,hwkc.hw_name) AS reported_by
				FROM global_event
				LEFT JOIN hardware AS hw ON hw.hw_id = ge_hw_id AND ge_type = ' . GlobalEventType::DOMO . '
				LEFT JOIN keychain ON key_id = ge_hw_id AND ge_type = ' . GlobalEventType::DKEEP . '
				LEFT JOIN hardware AS hwkc ON hwkc.hw_serial = ge_hw_serial AND ge_type = ' . GlobalEventType::DKEEP . '
				INNER JOIN company ON com_id = ge_com_id 
				LEFT JOIN users_info ON ui_id = hw.hw_user
				LEFT JOIN dshield_event_relation ON der_event_id = ge_id 
				LEFT JOIN dshield_event ON dse_event_id = ge_id OR dse_id = der_dse_id
				WHERE ' . $where . ' 
				ORDER BY ge_id DESC
				LIMIT ?';
		
		$frames = $this->db->get_results( $sql, ARRAY_A, $data );
		
		$events = NULL;
		
		if ( isset( $frames ) )
		{
			$events = array();
			
			foreach ( $frames as $frame )
			{
				$events[] = $this->parse_frame( $frame, $user );
			}
		}
		
		return $events;
	}
	
	/** could be an array of companies or just a com_id */
	public static function get_company_filter( $filter_company = NULL, $field_name = 'com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM global_event WHERE ge_com_id = ?', array( $com_id ) );
	}
}
