<?php
class DTransFrames_model extends CI_Model
{
	public function add( $com_id, $serial, $timestamp, $frame )
	{
		$this->db->query( SQL::make_insert_pdo( 'dtrans_frames', array( 'com_id', 'serial', 'timestamp', 'frame' ), '', 'dt_' ), array( $com_id, $serial, $timestamp, $frame ) );
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'dt_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $offset = 0, $fields_get = '*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM dtrans_frames ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( $offset );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
}
