<?php
class DShieldEventStates_model extends CI_Model
{
	public function add( $com_id, $name )
	{
		$this->db->query( SQL::make_insert_pdo( 'dshield_event_states', array( 'com_id', 'name' ), '', 'des_' ), array( $com_id, $name ) );
	
		return $this->db->insert_id();
	}
	
	public function update( $id, $name )
	{
		$this->db->query( SQL::make_update_pdo( 'dshield_event_states', array( 'name', 'id' ), 'id', '', 'des_' ), array( $name, $id ) );
	
		return $id;
	}
	
	public function delete( $id )
	{
		$this->db->query( SQL::make_delete_pdo( 'dshield_event_states', 'des_id' ), array( $id ) );
	}
	
	public function exists( $id )
	{
		return $this->db->get_var( 'SELECT 1 FROM dshield_event_states WHERE des_id = ? LIMIT 1', array( $id ) );
	}
	
	public function get_all( $filter )
	{
		$where		= '';
		
		SQL::prepare_filter( $where, $filter, FALSE );
		
		return $this->db->get_results( 'SELECT * FROM dshield_event_states ' . $where, ARRAY_A );
	}
	
	public function create_default( $com_id )
	{
		 $this->add( $com_id, "ROBO" );
		 $this->add( $com_id, "ALARMA FALSA - USUARIO" );
		 $this->add( $com_id, "ALARMA FALSA - EQUIPO" );
		 $this->add( $com_id, "ALARMA FALSA - DESCONOCIDO" );
		 $this->add( $com_id, "TECNICO PROBANDO" );
		 $this->add( $com_id, "USUARIO PROBANDO" );
		 $this->add( $com_id, "CONTROL APERTURA Y CIERRE" );
		 $this->add( $com_id, "INTENTO DE ROBO" );
		 $this->add( $com_id, "FALLA TECNICA" );
		 $this->add( $com_id, "ASALTO" );
		 $this->add( $com_id, "SUPERVISION GENERAL" );
	}
}
