<?php
class DShieldEventHistory_model extends CI_Model
{
	public function add( $dse_id, $status, $observations, $uid )
	{
		$this->db->query( SQL::make_insert_pdo( 'dshield_event_history', array( 'dse_id', 'uid', 'status', 'observations' ), '', 'deh_' ), array( $dse_id, $uid, $status, $observations ) );
		
		return $this->db->insert_id();
	}
	
	public function get_all( $dse_id )
	{
		return $this->db->get_results( 'SELECT
											dshield_event_history.*,
											CASE 
												WHEN utype = 1 THEN 
													( SELECT CONCAT( ui_lastname, \' \', ui_name ) FROM users_info WHERE ui_uid = deh_uid )
												WHEN utype = 2 THEN 
													( SELECT com_name FROM company WHERE com_uid = deh_uid )
												ELSE 
													uname
											END
											AS author, 
											dshield_event_history.deh_status AS event_state 
										FROM dshield_event_history 
										INNER JOIN dshield_event ON dse_id = deh_dse_id  
										INNER JOIN users ON uid = deh_uid 
										WHERE deh_dse_id = ? ORDER BY deh_id DESC', ARRAY_A, array( $dse_id ) );
	}
}
