<?php
class DShieldEventChat_model extends CI_Model
{
	public function add( $event_id, $uid, $msg )
	{
		$this->db->query( SQL::make_insert_pdo( 'dshield_event_chat', array( 'dse_id', 'uid', 'msg' ), '', 'dsec_' ), array( $event_id, $uid, $msg ) );
		
		return $this->db->insert_id();
	}
	
	public function get_conversation( $event_id, $last_chat_id = 0 )
	{
		$sql = 'SELECT dshield_event_chat.*,
				CASE 
					WHEN utype = 1 THEN 
						( SELECT CONCAT( ui_lastname, \' \', ui_name ) FROM users_info WHERE ui_uid = dsec_uid )
					WHEN utype = 2 THEN 
						( SELECT com_name FROM company WHERE com_uid = dsec_uid )
					ELSE 
						uname
				END
				AS author
				FROM dshield_event_chat 
				INNER JOIN users ON uid = dsec_uid 
				WHERE dsec_dse_id = ? AND dsec_id > ?
				ORDER BY dsec_id ASC';
		
		return $this->db->get_results( $sql, ARRAY_A, array( $event_id, $last_chat_id ) );
	}
}
