<?php
class DShieldEvent_model extends CI_Model
{
	const DSHIELD_STATUS_OPEN = '';
	
	public function add( $event_id, $com_id, $hw_id, $uid, $status = self::DSHIELD_STATUS_OPEN )
	{
		$fields = array( 'event_id', 'com_id', 'hw_id', 'uid', 'status' );
		$values = array( $event_id, $com_id, $hw_id, $uid, $status );
		
		$this->db->query( SQL::make_insert_pdo( 'dshield_event', $fields, '', 'dse_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function update( $id, $status, $observations, $closed_uid, $closed_timestamp = NULL )
	{
		$fields = array( 'status', 'observations', 'closed', 'closed_uid', 'id' );
		$values = array( $status, $observations, $closed_timestamp, $closed_uid, $id );
		
		$this->db->query( SQL::make_update_pdo( 'dshield_event', $fields, 'id', '', 'dse_' ), $values );
		
		return $id;
	}
	
	/** could be an array of companies or just a com_id */
	public static function get_company_filter( $filter_company = NULL, $field_name = 'dse_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	protected function get_author_sql( $table_alias = 'ucreator', $field_user = 'dse_uid', $field_name = 'creator' )
	{
		return "CASE 
					WHEN {$table_alias}.utype = 1 THEN 
						( SELECT CONCAT( ui_lastname, ' ', ui_name ) FROM users_info WHERE ui_uid = {$field_user} )
					WHEN {$table_alias}.utype = 2 THEN 
						( SELECT com_name FROM company WHERE com_uid = {$field_user} )
					ELSE 
						{$table_alias}.uname
				END
				AS {$field_name}";
	}
	
	public function get_event_sql( $filter, $inner = '' )
	{
		$this->load->model('GlobalEvent_model');
		
		$sql = 'SELECT 
					dshield_event.*, 
					hw_name, 
					hw_address, 
					hw_serial, 
					hw_code, 
					hw_id, 
					key_id,
					key_owner_lastname,
					key_owner_name,
					key_owner_phone,
					key_owner_cellphone,
					ge_type,
					' . $this->get_author_sql( 'ucreator', 'dse_uid', 'creator' ) . ', 
					' . $this->get_author_sql( 'ucloser', 'dse_closed_uid', 'closer' ) . '
				FROM dshield_event 
				INNER JOIN global_event ON dse_event_id = ge_id 
				LEFT JOIN hardware ON dse_hw_id = hw_id AND ge_type = ' . GlobalEventType::DOMO . ' 
				LEFT JOIN keychain ON dse_hw_id = key_id AND ge_type = ' . GlobalEventType::DKEEP . ' 
				INNER JOIN users AS ucreator ON dse_uid = ucreator.uid 
				' . $inner . ' 
				LEFT JOIN users AS ucloser ON dse_closed_uid = ucloser.uid
				WHERE ' . $filter . ' 
				LIMIT 1';
		
		return $sql;
	}
	
	public function get( $id )
	{
		return $this->db->get_row( $this->get_event_sql( 'dse_id = ?' ), ARRAY_A, array( $id ) );
	}
	
	public function by_event_id( $event_id )
	{
		return $this->db->get_row( $this->get_event_sql( 'dse_event_id = ?' ), ARRAY_A, array( $event_id ) );
	}
	
	public function get_open( $hw_id )
	{
		return $this->db->get_row( $this->get_event_sql( 'dse_hw_id = ? AND (dse_status <> \'\') IS NOT TRUE ORDER BY dse_id DESC' ), ARRAY_A, array( $hw_id ) );
	}
	
	public function by_relation( $event_id )
	{
		return $this->db->get_row( $this->get_event_sql( 'der_event_id = ?', 'INNER JOIN dshield_event_relation ON der_dse_id = dse_id' ), ARRAY_A, array( $event_id ) );
	}
	
	public function by_date( $hw_id, $event_id )
	{
		$sql = $this->get_event_sql( '	dse_hw_id = ? AND 
										dse_opened >= ' . SQL::from_unix_time('df_hw_timestamp') . ' AND 
										dse_closed <= ' . SQL::from_unix_time('df_hw_timestamp'), 
										'INNER JOIN data_frames ON df_id = ?' );
		
		return $this->db->get_row( $sql, ARRAY_A, array( $event_id, $hw_id ) );
	}
	
	public function by_near_date( $hw_id, $event_id )
	{
		$sql = $this->get_event_sql( '	dse_hw_id = ? AND 
										(
											abs(' . SQL::secs_from( 'df_hw_timestamp', 'dse_opened' ) . ' ) < 3600 OR 
											abs(' . SQL::secs_from( 'df_hw_timestamp', 'dse_closed' ) . ' ) < 3600
										)', 
										'INNER JOIN data_frames ON df_id = ?' );
		
		return $this->db->get_row( $sql, ARRAY_A, array( $event_id, $hw_id ) );
	}
	
	public function add_relation( $dse_id, $event_id )
	{
		if ( !$this->exists_relation( $dse_id, $event_id ) )
		{
			$this->db->query( SQL::make_insert_pdo( 'dshield_event_relation', array( 'dse_id', 'event_id' ), '', 'der_' ), array( $dse_id, $event_id ) );
			
			return $this->db->insert_id();
		}
	}
	
	public function exists_relation( $dse_id, $event_id )
	{
		return $this->db->get_var(  'SELECT 1 FROM dshield_event_relation WHERE der_dse_id = ? AND der_event_id = ?', array( $dse_id, $event_id ) );
	}
	
	public function get_events( $filter_company, $seconds_since = 7200, $since_event_id = NULL )
	{
		$this->load->model('GlobalEvent_model');
		
		$data	= array();
		$where	= self::get_company_filter( $filter_company );
		
		if ( NULL != $seconds_since )
		{
			if ( '' != $where )
			{
				$where .= ' AND ';
			}
			
			array_unshift( $data, $seconds_since );
			
			$where .= ' dse_opened >= ' . SQL::get_seconds_back( $seconds_since );
		}
		
		if ( NULL != $since_event_id )
		{
			if ( '' != $where )
			{
				$where .= ' AND ';
			}
			
			array_unshift( $data, $since_event_id );
			
			$where .= ' dse_event_id > ? ';
		}
		
		$sql = 'SELECT dshield_event.*, hw_name, hw_address, hw_serial, hw_code, key_id, key_owner_lastname, key_owner_name, key_owner_phone, key_owner_cellphone, ge_type,
				( SELECT array_to_json(array_agg(row_to_json(rels))) FROM ( SELECT * FROM dshield_event_relation WHERE der_dse_id = dse_id ) AS rels ) AS relations
				FROM dshield_event 
				INNER JOIN global_event ON dse_event_id = ge_id 
				LEFT JOIN hardware ON dse_hw_id = hw_id AND ge_type = ' . GlobalEventType::DOMO . ' 
				LEFT JOIN keychain ON dse_hw_id = key_id AND ge_type = ' . GlobalEventType::DKEEP . ' 
				WHERE ' . $where;
		
		return $this->db->get_results( $sql, ARRAY_A, $data );
	}
}
