<?php
class DataFrames_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hw_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function get_repeated_messages_by_time_sql( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL, $no_to_hex = FALSE, $with_hwg_name = FALSE )
	{
		$filter = self::get_company_filter( $filter_company );
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$groups_filter = '';
		
		if ( '' != $filter_groups )
		{
			$filter_groups = SQL::get_or_filter( $filter_groups, 'hwgl_group' );
			$groups_filter	= 'INNER JOIN hardware_group_link ON hw_id = hwgl_hw_id AND ' . $filter_groups;
			$groups_filter .= "\n INNER JOIN hardware_group ON hwg_id = hwgl_group";
		}
		
		$sql = "SELECT 
					" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
					hw_id,
					" . ( $no_to_hex ? "df_hw_serial" : "to_hex(df_hw_serial)" ) . " AS serial,
					timestamp,
					SUM(repeats) AS repeated
				FROM
				(
					SELECT
						" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
						df_hw_serial,
						timestamp,
						df_msg_type,
						df_frame_data,
						SUM(repeats) AS repeats
					FROM (
						SELECT 
							" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
							df_hw_serial, 
							( floor( df_hw_timestamp / 1800 ) * 1800 ) AS timestamp,
							df_msg_type,
							df_frame_data,
							COUNT(df_msg_type)-1 AS repeats
						FROM data_frames
						INNER JOIN hardware ON hw_serial = df_hw_serial 
						$groups_filter 
						WHERE
							df_hw_serial != 0 AND
							( df_msg_type = 24 OR df_msg_type = 39 ) AND
							df_frame_data NOT LIKE '_552______' AND
							df_frame_data NOT LIKE '______119_' AND
							df_hw_timestamp >= $start_time AND
							df_hw_timestamp <= $end_time 
							$filter
						GROUP BY
							" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
							df_hw_serial,
							timestamp,
							df_msg_type,
							df_frame_data
						HAVING COUNT(df_msg_type) > 1
					) AS repeated_msg_ori
					GROUP BY 
						" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
						df_hw_serial,
						timestamp,
						df_msg_type,
						df_frame_data
				) AS repeated_msg
				INNER JOIN hardware ON hw_serial = df_hw_serial
				GROUP BY 
					" . ( $with_hwg_name ? 'hwg_name, ' : '' ) . "
					hw_id,
					df_hw_serial,
					timestamp
				ORDER BY timestamp ASC";
		
		return $sql;
	}
	
	public function get_repeated_messages_by_time( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		return $this->db->get_results( $this->get_repeated_messages_by_time_sql( $start_time, $end_time, $filter_company, $filter_groups ), ARRAY_A );
	}
	
	public function get_repeated_from_time_range_sql( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$inner_sql = '(' . $this->get_repeated_messages_by_time_sql( $start_time, $end_time, $filter_company, $filter_groups, TRUE ) . ') AS repeated_msg_final';
		
		$filter_series = SQL::get_or_filter( $filter_company, 'com_id' );
		$filter_series = '' != $filter_series ? 'WHERE ' . $filter_series : '';
		
		$interval = 3600;
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	com_name AS type,  
						generate_series AS time, 
						0 AS total
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN company ON TRUE
				$filter_series
				GROUP BY time, com_name
				ORDER BY generate_series ASC, com_name ASC ) AS base_series";
		
		$real_sql = "( SELECT 
					com_name AS type,
					( floor( timestamp / 3600 ) * 3600 ) AS time,
					SUM(repeated) AS total
				FROM
				$inner_sql
				INNER JOIN hardware ON hw_serial = serial 
				INNER JOIN company ON com_id = hw_company 
				GROUP BY 
					com_name,
					( floor( timestamp / 3600 ) * 3600 )
				ORDER BY ( floor( timestamp / 3600 ) * 3600 ) ASC ) AS real_series";
		
		$full_sql	=  "SELECT base_series.type, 
								base_series.time, 
								COALESCE(real_series.total,0) AS total
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON base_series.time = real_series.time AND base_series.type = real_series.type";
		
		return $full_sql;
	}
	
	public function get_repeated_from_time_range( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		return $this->db->get_results( $this->get_repeated_from_time_range_sql( $start_time, $end_time, $filter_company, $filter_groups ), ARRAY_A );
	}
	
	public function get_repeated_from_time_range_group_sql( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$inner_sql = '(' . $this->get_repeated_messages_by_time_sql( $start_time, $end_time, $filter_company, $filter_groups, TRUE, TRUE ) . ') AS repeated_msg_final';
		
		$filter_series = SQL::get_or_filter( $filter_company, 'hwg_company' );
		$filter_series = '' != $filter_series ? 'WHERE ' . $filter_series : '';
		
		$filter_serie = array(
			array(
				'field_name' => 'hwg_company',
				'filter_val' => $filter_company
			),
			array(
				'field_name' => 'hwg_id',
				'filter_val' => $filter_groups
			)
		);
		
		$filter_series = SQL::build_filter( $filter_serie );	
		
		$interval = 3600;
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	hwg_name AS type,  
						generate_series AS time, 
						0 AS total
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN hardware_group ON TRUE
				$filter_series
				GROUP BY hwg_name, time
				ORDER BY generate_series ASC, hwg_name ASC ) AS base_series";
		
		$real_sql = "( SELECT 
					hwg_name AS type,
					( floor( timestamp / 3600 ) * 3600 ) AS time,
					SUM(repeated) AS total
				FROM
				$inner_sql
				INNER JOIN hardware ON hw_serial = serial 
				INNER JOIN company ON com_id = hw_company 
				GROUP BY 
					hwg_name,
					( floor( timestamp / 3600 ) * 3600 )
				ORDER BY ( floor( timestamp / 3600 ) * 3600 ) ASC ) AS real_series";
		
		$full_sql	=  "SELECT base_series.type, 
								base_series.time, 
								COALESCE(real_series.total,0) AS total
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON base_series.time = real_series.time AND base_series.type = real_series.type";
		
		return $full_sql;
	}
	
	public function get_repeated_from_time_range_group( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		return $this->db->get_results( $this->get_repeated_from_time_range_group_sql( $start_time, $end_time, $filter_company, $filter_groups ), ARRAY_A );
	}
	
	public function get_messages_by_company_query( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$filter = self::get_company_filter( $filter_company );
		
		if ( isset( $filter ) && !empty( $filter ) )
		{
			$filter = ' AND ' . $filter;
		}
		
		$filter_series = SQL::get_or_filter( $filter_company, 'com_id' );
		$filter_series = '' != $filter_series ? 'WHERE ' . $filter_series : '';
		
		$groups_filter = '';
		
		if ( '' != $filter_groups )
		{
			$groups_filter	= 'INNER JOIN hardware_group_link ON hw_id = hwgl_hw_id AND ' . $filter_groups;
			$groups_filter .= "\n INNER JOIN hardware_group ON hwg_id = hwgl_group";
		}
		
		$interval = 900;
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	com_name AS type,  
						generate_series AS time, 
						0 AS total
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN company ON TRUE
				$groups_filter
				$filter_series
				GROUP BY com_name, time
				ORDER BY generate_series ASC, com_name ASC ) AS base_series";
		
		$sql = "SELECT 
				com_name AS type,
				( floor( df_hw_timestamp / 900 ) * 900 ) AS time,
				COUNT(df_id) AS total
			FROM data_frames
			INNER JOIN hardware ON hw_serial = df_hw_serial 
			INNER JOIN company ON hw_company = com_id
			$groups_filter 
			WHERE
				df_hw_serial != 0 AND
				df_msg_type = 24 AND
				df_frame_data NOT LIKE '______119_' AND
				df_frame_data NOT LIKE '______120_' AND
				df_frame_data NOT LIKE '______121_' AND
				df_hw_timestamp >= $start_time AND
				df_hw_timestamp <= $end_time 
				$filter
			GROUP BY 
				com_name,
				( floor( df_hw_timestamp / 900 ) * 900 )
			ORDER BY ( floor( df_hw_timestamp / 900 ) * 900 ) ASC, com_name ASC";
		
		$real_sql = "( $sql ) AS real_series";
		
		$full_sql	=  "SELECT base_series.type, 
								base_series.time, 
								COALESCE(real_series.total,0) AS total
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON base_series.time = real_series.time AND base_series.type = real_series.type";
		
		return $full_sql;
	}
	
	public function get_messages_by_company( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		return $this->db->get_results( $this->get_messages_by_company_query( $start_time, $end_time, $filter_company, $filter_groups ), ARRAY_A );
	}
	
	public function get_messages_by_company_rows( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$sql = 'SELECT COUNT(DISTINCT q1.time) FROM (' . $this->get_messages_by_company_query( $start_time, $end_time, $filter_company, $filter_groups ) . ') AS q1';
		return $this->db->get_var( $sql );
	}
}
