<?php
class ConfigLog_model extends CI_Model
{
	protected $table = '';
	protected $abbr = '';
	
	function __construct( $table, $abbr )
	{
		parent::__construct();
		
		$this->table = $table;
		$this->abbr = $abbr;
	}
	
	public function add( $com_id, $timestamp, $msg )
	{
		$this->db->set_qd( array( $com_id, $timestamp, $msg ) );
		$this->db->query( SQL::make_insert_pdo( $this->table, array( 'com_id', 'timestamp', 'msg' ), '', $this->abbr ) );
	}
	
	public function get( $com_id, $last_id = NULL, $limit = 100 )
	{
		$filters = '';
		
		if( isset( $last_id ) ) 
		{
			$filters = 'AND ' . $this->abbr . 'id > ?';
			
			$this->db->set_qd(array($com_id, $last_id));
		}
		else
		{
			$this->db->set_qd(array($com_id));
		}

		return $this->db->get_results('SELECT to_timestamp(' . $this->abbr . 'timestamp) AS time, ' . $this->abbr . 'msg AS msg, ' . $this->abbr . 'id as id FROM ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ? ' . $filters . ' ORDER BY ' . $this->abbr . 'id DESC LIMIT ' . $limit . ' OFFSET 0', ARRAY_A );
	}
	
	public function get_last( $com_id )
	{
		return $this->db->get_row( 'SELECT to_timestamp(' . $this->abbr . 'timestamp) AS last_tick, ' . $this->abbr . 'id AS last_tick_id 
									FROM ' . $this->table . ' 
									WHERE ' . $this->abbr . 'com_id = ? 
									ORDER BY ' . $this->abbr . 'id DESC LIMIT 1 OFFSET 0', 
									ARRAY_A, 
									array( $com_id )
		);
	}
	
	public function get_from( $com_id, $timestamp )
	{
		return $this->db->get_results( 'SELECT to_timestamp(' . $this->abbr . 'timestamp) AS time, ' . $this->abbr . 'msg AS msg, ' . $this->abbr . 'id as id FROM ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ? AND ' . $this->abbr . 'timestamp >= ? ORDER BY ' . $this->abbr . 'id DESC', ARRAY_A, array( $com_id, $timestamp ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ?', array( $com_id ) );
	}
}
