<?php
abstract class ConfigCommand_model extends CI_Model
{
	protected $table = '';
	protected $abbr = '';
	
	function __construct( $table, $abbr )
	{
		parent::__construct();
		
		$this->table = $table;
		$this->abbr = $abbr;
	}
	
	public function update_state( $id, $state )
	{
		$this->db->query( SQL::make_update_pdo( $this->table, array( 'state', 'id' ), 'id', '', $this->abbr ), array( $state, $id ) );
	}
	
	public function get_pending_commands( $com_id )
	{
		$sql = "SELECT " . $this->table . ".* FROM " . $this->table . " 
				INNER JOIN hardware ON hw_serial = " . $this->abbr . "serial 
				INNER JOIN company ON com_id = hw_company
				WHERE " . $this->abbr . "state = 'PENDING_SEND' AND com_id = ? AND ( " . $this->abbr . "sendtime IS NULL OR " . $this->abbr . "sendtime <= " . SQL::unix_timestamp() . " )
				ORDER BY " . $this->abbr . "id ASC";
		
		return $this->db->get_results( $sql, ARRAY_A, array( $com_id ) );
	}
	
	public function set_waiting_response( $com_id )
	{
		$this->db->query( "UPDATE " . $this->table . " SET " . $this->abbr . "state = 'WAITING_RESPONSE'
							FROM  hardware, company 
							WHERE	hw_serial = " . $this->abbr . "serial AND 
									com_id = hw_company AND 
									" . $this->abbr . "state = 'PENDING_SEND' AND 
									com_id = ? AND ( " . $this->abbr . "sendtime IS NULL OR " . $this->abbr . "sendtime <= " . SQL::unix_timestamp() . " )", array( $com_id ) );
	}
	
	public function get_active_commands_count( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return $this->db->get_var("SELECT COUNT(" . $this->abbr . "id) FROM " . $this->table . " 
										INNER JOIN hardware ON hw_serial = " . $this->abbr . "serial 
										INNER JOIN company ON com_id = hw_company
										WHERE ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' ) AND com_id = ? AND " . $this->abbr . "batch_id = ?", array( $com_id, $batch_id ) );
	}
	
	public function is_running_commands( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return 0 != $batch_id && intval( $this->get_active_commands_count( $com_id ) ) > 0;
	}
	
	abstract public function get_last_company_batch_id( $com_id );
	
	public function get_last_batch_id( $com_id = null )
	{
		if ( null == $com_id )
		{
			return intval( $this->db->get_var( "SELECT COALESCE(MAX(" . $this->abbr . "batch_id),0) AS max_id FROM " . $this->table ) );
		}
		
		return intval( $this->db->get_var( "SELECT COALESCE(MAX(" . $this->abbr . "batch_id),0) AS max_id 
											FROM " . $this->table . " 
											INNER JOIN hardware ON " . $this->abbr . "serial = hw_serial 
											WHERE hw_company = ?", array( $com_id ) ) );
	}
	
	public function get_next_batch_id()
	{
		return $this->get_last_batch_id() + 1;
	}
	
	public function cancel_last_batch( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		$this->db->query( "UPDATE " . $this->table . " SET " . $this->abbr . "state = 'CANCELLED' 
							WHERE " . $this->abbr . "batch_id = ? AND ( " . $this->abbr . "state = 'WAITING_RESPONSE' OR " . $this->abbr . "state = 'PENDING_SEND' )", array( $batch_id ) );
	}
	
	public function get_state( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		if ( 0 == $batch_id )
		{
			return NULL;
		}
		
		return $this->db->get_row( 
			"SELECT 
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state = 'EXECUTED' ) AS ok,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND ( " . $this->abbr . "state = 'ERROR_TIMEOUT' ) ) AS noresp,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' ) ) AS pending_send,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state = 'WAITING_RESPONSE' ) AS sent,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND ( " . $this->abbr . "state != 'PENDING_SEND' AND " . $this->abbr . "state != 'WAITING_RESPONSE' AND " . $this->abbr . "state != 'OK' ) ) AS received,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND ( " . $this->abbr . "state LIKE 'ERROR%' AND " . $this->abbr . "state != 'ERROR_TIMEOUT' ) ) AS errors,
( SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state != 'OK' ) AS total
			"
		, ARRAY_A );
	}
	
	public function get_configured_commands( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return $this->db->get_results( "SELECT " . $this->abbr . "serial, to_hex(" . $this->abbr . "serial) AS mac FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state = 'EXECUTED'", ARRAY_A );
	}
	
	public function get_not_configured_commands( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return $this->db->get_results( "SELECT " . $this->abbr . "serial, to_hex(" . $this->abbr . "serial) AS mac FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state != 'EXECUTED'", ARRAY_A );
	}
	
	public function get_configured_commands_macs( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return $this->db->get_results( "SELECT DISTINCT to_hex(" . $this->abbr . "serial) AS mac FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state = 'EXECUTED'", ARRAY_A );
	}
	
	public function get_not_configured_commands_macs( $com_id )
	{
		$batch_id = $this->get_last_company_batch_id( $com_id );
		
		return $this->db->get_results( "SELECT DISTINCT to_hex(" . $this->abbr . "serial) AS mac FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = $batch_id AND " . $this->abbr . "state != 'EXECUTED'", ARRAY_A );
	}
	
	public function batch_is_done_successfully( $batch_id )
	{
		return 0 == $this->db->get_var( "SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = ? AND ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' OR " . $this->abbr . "state LIKE 'ERROR%' OR " . $this->abbr . "state = 'CANCELLED' )", array( $batch_id ) );
	}
	
	public function batch_is_done( $batch_id )
	{
		return 0 == $this->db->get_var( "SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = ? AND ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' )", array( $batch_id ) );
	}
	
	public function get_batch( $batch_id )
	{
		return $this->db->get_results( "SELECT " . $this->table . ".*, hw_id FROM " . $this->table . " LEFT JOIN hardware ON " . $this->abbr . "serial = hw_serial WHERE " . $this->abbr . "batch_id = ?", ARRAY_A, array( $batch_id ) );
	}
	
	public function batch_is_done_successfully_for_serial( $batch_id, $hw_serial )
	{
		return 0 == $this->db->get_var( "SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = ? AND " . $this->abbr . "serial = ? AND ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' OR " . $this->abbr . "state LIKE 'ERROR%' OR " . $this->abbr . "state = 'CANCELLED' )", array( $batch_id, $hw_serial ) );
	}
	
	public function batch_is_done_for_serial( $batch_id, $hw_serial )
	{
		return 0 == $this->db->get_var( "SELECT COUNT(" . $this->abbr . "serial) FROM " . $this->table . " WHERE " . $this->abbr . "batch_id = ? AND " . $this->abbr . "serial = ? AND ( " . $this->abbr . "state = 'PENDING_SEND' OR " . $this->abbr . "state = 'WAITING_RESPONSE' )", array( $batch_id, $hw_serial ) );
	}
	
	public function get_batch_from_serial( $batch_id, $hw_serial )
	{
		return $this->db->get_results( "SELECT " . $this->table . ".*, hw_id FROM " . $this->table . " LEFT JOIN hardware ON " . $this->abbr . "serial = hw_serial WHERE " . $this->abbr . "batch_id = ? AND " . $this->abbr . "serial = ?", ARRAY_A, array( $batch_id, $hw_serial ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM ' . $this->table . ' WHERE ' . $this->abbr . 'serial IN ( SELECT hw_serial FROM hardware WHERE hw_company = ? )', array( $com_id ) );
	}
}
