<?php

class CompanyUser_model extends CI_Model
{
	public function get( $uid, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT * FROM company_user INNER JOIN users ON cu_user = uid WHERE cu_user = ?', $output, array( $uid ) );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'cu_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}

	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= self::get_company_filter( $filter_company );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM company_user INNER JOIN users ON cu_user = uid INNER JOIN company ON cu_com_id = com_id ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function add( $uid, $com_id, $config_hw, $type, $dshield_guard = 0, $access_control = 1 )
	{
		$fields = array( 'user', 'com_id', 'config_hw', 'type', 'dshield_guard', 'access_control' );
		$values = array( $uid, $com_id, $config_hw, $type, $dshield_guard, $access_control );

		$this->db->set_qd( $values );

		return $this->db->query( SQL::make_insert_pdo( 'company_user', $fields, '', 'cu_' ) );
	}
	
	public function edit_company( $uid, $com_id )
	{
		$this->db->set_qd( array( $com_id, $uid ) );
		
		$this->db->query( SQL::make_update_pdo( 'company_user', array( 'cu_com_id', 'cu_user' ), 'cu_user' ) );
	}
	
	public function create( $form, $com_id )
	{
		$this->db->trans_start();
		
		CI()->load->model('User_model');

		CI()->User_model->add( $form['uname'], $form['upass'], $form['umail'], $form['utype'] );

		$uid = $this->db->last_insert_id();

		$this->add( $uid, $com_id, isset( $form['config_hw'] ) ? $form['config_hw'] : 0, isset( $form['type'] ) ? $form['type'] : 0, isset( $form['dshield_guard'] ) ? $form['dshield_guard'] : 0, isset( $form['access_control'] ) ? $form['access_control'] : 0 );

		$this->db->trans_complete();
		
		return $this->db->last_insert_id();
	}

	public function update( $form, $com_id = NULL )
	{
		$this->db->trans_start();

		$fields = array( 'umail', 'uname' );
		$values = array( strtolower( $form['umail'] ), strtolower( $form['uname'] ) );
		
		if ( isset( $form['utype'] ) )
		{
			$fields[] = 'utype';
			$values[] = $form['utype'];
		}
		
		if ( strlen( $form['upass'] ) > 0 )
		{
			$fields[] = 'upass';
			$values[] = (string)get_password_hash( $form['upass'] );
		}

		$fields[] = 'uid';
		$values[] = $form['uid'];

		$this->db->set_qd( $values );

		$this->db->query( SQL::make_update_pdo( 'users', $fields, 'uid' ) );
		
		if ( NULL != $com_id )
		{
			$this->edit_company( $form['uid'], $com_id );
		}
		
		if ( !isset( $form['type'] ) )
		{
			$form['type'] = 0;
		}
		
		if ( isset( $form['config_hw'] ) || isset( $form['type'] ) )
		{
			$this->db->query( SQL::make_update_pdo( 'company_user', array( 'config_hw', 'type', 'user' ), 'user', '', 'cu_' ), array( $form['config_hw'], $form['type'], $form['uid'] ) );
		}
		
		if ( isset( $form['dshield_guard'] ) )
		{
			$this->db->query( SQL::make_update_pdo( 'company_user', array( 'dshield_guard', 'user' ), 'user', '', 'cu_' ), array( $form['dshield_guard'], $form['uid'] ) );
		}
		
		if ( isset( $form['access_control'] ) )
		{
			$this->db->query( SQL::make_update_pdo( 'company_user', array( 'access_control', 'user' ), 'user', '', 'cu_' ), array( $form['access_control'], $form['uid'] ) );
		}
		
		if ( isset( $form['com_id'] ) && isset( $form['name'] ) )
		{
			$commod = load_model('Company_model');
			
			$commod->update( $form );
			
			if ( isset( $form['openkey_hostname'] ) )
			{
				$commod->update_openkey( $form );
			}
		}
		
		$this->db->trans_complete();
	}
	
	public function delete( $uid )
	{
		$this->db->trans_start();

		$this->db->set_qd( array( $uid ) );

		$this->db->query( SQL::make_delete_pdo( 'users', 'uid' ) );

		$this->db->set_qd( array( $uid ) );

		$this->db->query( 'DELETE FROM company_user WHERE cu_user = ?' );

		$this->db->trans_complete();
	}
	
	public function delete_from_company( $com_id )
	{
		$res = $this->db->get_results( 'SELECT uid FROM users INNER JOIN company_user ON cu_user = uid WHERE cu_com_id = ?', ARRAY_A, array( $com_id ) );
		
		if ( isset( $res ) )
		{
			foreach ( $res as $row )
			{
				$this->delete( $row['uid'] );
			}
		}
	}
}
