<?php

class CompanyTimeFrameConfig_model extends CI_Model
{
	public static $field = array( 'com_id', 'time_in', 'time_out' );
	
	public function add( $com_id, $time_in, $time_out )
	{
		$this->db->query( SQL::make_insert_pdo( 'company_time_frame_config', self::$field, '', 'ctfc_' ), array( $com_id, $time_in, $time_out ) );
	}
	
	public function update( $com_id, $time_in, $time_out )
	{
		$this->db->query( SQL::make_update_pdo( 'company_time_frame_config', self::$field, 'com_id', '', 'ctfc_' ), array( $time_in, $time_out, $com_id ) );
	}
	
	public function get( $com_id )
	{
		$res = $this->db->get_row( 'SELECT * FROM company_time_frame_config WHERE ctfc_com_id = ? LIMIT 1', ARRAY_A, array( $com_id ) );
		
		if ( !isset( $res ) )
		{
			$this->add( $com_id, 15, 15 );
			
			$res = array();
			$res['ctfc_com_id'] = $com_id;
			$res['ctfc_time_in'] = 15;
			$res['ctfc_time_out'] = 15;
		}
		
		return $res;
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM company_time_frame_config WHERE ctfc_com_id = ?', array( $com_id ) );
	}
}
