<?php

class CompanyTimeFrame_model extends CI_Model
{
	public static $field = array( 'com_id', 'type', 'time_start', 'time_end', 'rc_code' );
	
	public function add( $com_id, $type, $time_start, $time_end, $rc_codes = NULL )
	{
		$RfidUserCitymesh_model = load_model('RfidUserCitymesh_model');
		
		$rc_codes = NULL == $rc_codes ? $RfidUserCitymesh_model->get_array( User()->get_user_id() ) : $rc_codes;
		
		if ( isset( $rc_codes ) )
		{
			foreach ( $rc_codes as $rc_code )
			{
				$this->db->query( SQL::make_insert_pdo( 'company_time_frame', self::$field, '', 'ctf_' ), array( $com_id, $type, $time_start, $time_end, $rc_code ) );
			}
		}
		
		return $this->db->last_insert_id();
	}
	
	public function get_id( $id )
	{
		return $this->db->get_row( 'SELECT * FROM company_time_frame WHERE ctf_id = ? LIMIT 1', ARRAY_A, array( $id ) );
	}
	
	public function get( $com_id, $type, $rc_codes = NULL )
	{
		$RfidUserCitymesh_model = load_model('RfidUserCitymesh_model');
		
		$rc_codes = NULL == $rc_codes ? $RfidUserCitymesh_model->get_array( User()->get_user_id() ) : $rc_codes;
		
		$filter = SQL::get_or_filter( $rc_codes, 'ctf_rc_code' );
		
		if ( '' != $filter )
		{
			$filter = ' AND ' . $filter;
		}
		
		return $this->db->get_row( 'SELECT * FROM company_time_frame WHERE ctf_com_id = ? AND ctf_type = ? ' . $filter . ' ORDER BY ctf_time_end DESC LIMIT 1', ARRAY_A, array( $com_id, $type ) );
	}
	
	public function is_active( $com_id, $type, $rc_codes = NULL )
	{
		$RfidUserCitymesh_model = load_model('RfidUserCitymesh_model');
		
		$rc_codes = NULL == $rc_codes ? $RfidUserCitymesh_model->get_array( User()->get_user_id() ) : $rc_codes;
		
		$filter = SQL::get_or_filter( $rc_codes, 'ctf_rc_code' );
		
		if ( '' != $filter )
		{
			$filter = ' AND ' . $filter;
		}
		
		return NULL != $this->db->get_var( 'SELECT 1 FROM company_time_frame WHERE ctf_com_id = ? AND ctf_type = ? AND ctf_time_end >= ? ' . $filter . ' LIMIT 1', array( $com_id, $type, time() ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM company_time_frame WHERE ctf_com_id = ?', array( $com_id ) );
	}
}
