<?php
class CompanyConfig_model extends CI_Model
{
	protected $table = '';
	protected $abbr = '';
	
	function __construct( $table, $abbr )
	{
		parent::__construct();
		
		$this->table = $table;
		$this->abbr = $abbr;
	}
	
	public function get( $com_id )
	{
		$res = $this->db->get_row( 'SELECT * FROM ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ?', ARRAY_A, array( $com_id ) );
		
		if ( !isset( $res ) )
		{
			$res[$this->abbr . 'com_id'] = intval( $com_id );
			$res[$this->abbr . 'send_ok_interval'] = 15;
			$res[$this->abbr . 'send_err_interval'] = 100;
			$res[$this->abbr . 'send_max_per_mac'] = 4;
			$res[$this->abbr . 'max_resp_time_per_mac'] = 1;
			$res[$this->abbr . 'add_to_group'] = NULL;
			$res[$this->abbr . 'force_send'] = 0;
			$res[$this->abbr . 'cancel_batch'] = 0;
			
			if ( 0 != $com_id )
			{
				$this->add( $res[$this->abbr . 'com_id'], 
							$res[$this->abbr . 'send_ok_interval'], 
							$res[$this->abbr . 'send_err_interval'], 
							$res[$this->abbr . 'send_max_per_mac'], 
							$res[$this->abbr . 'max_resp_time_per_mac'], 
							$res[$this->abbr . 'add_to_group'],
							$res[$this->abbr . 'force_send']
				);
			}
		}
		
		return $res;
	}
	
	public function add( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $add_to_group, $force_send )
	{
		$fields = array( 'com_id', 'send_ok_interval', 'send_err_interval', 'send_max_per_mac', 'max_resp_time_per_mac', 'force_send' );
		$values = array( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $force_send );
		
		if ( NULL != $add_to_group && intval( $add_to_group ) != 0 )
		{
			$fields[] = 'add_to_group';
			$values[] = $add_to_group;
		}
		
		$this->db->set_qd( $values );
		
		$this->db->query( SQL::make_insert_pdo( $this->table, $fields, '', $this->abbr ) );
	}
	
	public function update( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $add_to_group, $force_send )
	{
		$fields = array( 'send_ok_interval', 'send_err_interval', 'send_max_per_mac', 'max_resp_time_per_mac', 'force_send' );
		$values = array( $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $force_send );
		
		if ( null != $add_to_group && intval( $add_to_group ) != 0 )
		{
			$fields[] = 'add_to_group';
			$values[] = $add_to_group;
		}
		
		$fields[] = 'com_id';
		$values[] = $com_id;
		
		$sql = SQL::make_update_pdo( $this->table, $fields, 'com_id', '', $this->abbr );
		
		$this->db->query( $sql, $values );
	}
	
	public function exists( $com_id )
	{
		return $this->db->get_var( 'SELECT 1 AS exists from ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function add_update( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $add_to_group = NULL, $force_send = 0 )
	{
		if ( $this->exists( $com_id ) )
		{
			$this->update( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $add_to_group, $force_send );
		}
		else
		{
			$this->add( $com_id, $send_ok_interval, $send_err_interval, $send_max_per_mac, $max_resp_time_per_mac, $add_to_group, $force_send );
		}
	}
	
	public function add_to_group_reset( $com_id )
	{
		$this->db->query( 'UPDATE ' . $this->table . ' SET ' . $this->abbr . 'add_to_group = NULL WHERE ' . $this->abbr . 'com_id = ?', array( $com_id ) );
	}
	
	public function set_batch_cancellation( $com_id, $active = TRUE )
	{
		$this->db->query( 'UPDATE ' . $this->table . ' SET ' . $this->abbr . 'cancel_batch = ? WHERE ' . $this->abbr . 'com_id = ?', array( $active == TRUE ? 1 : 0, $com_id ) );
	}
	
	public function reset_batch_cancellation( $com_id )
	{
		$this->set_batch_cancellation( $com_id, FALSE );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM ' . $this->table . ' WHERE ' . $this->abbr . 'com_id = ?', array( $com_id ) );
	}
	
	public function update_batch_id( $com_id, $batch_id )
	{
		$this->db->query( SQL::make_update_pdo( $this->table, array( 'batch_id', 'com_id' ), 'com_id', '', $this->abbr ), array( $batch_id, $com_id ) );
	}
}
