<?php
class Company_model extends CI_Model
{
	public static $def_fields = 'com_id,com_df_id,com_rec_id,com_uid,com_name,com_desc,com_city,com_phone,com_logo,com_apikey,com_hw_count,com_support,com_ssh_port,com_hw_report_freq,com_hw_state_low,com_hw_state_good,com_ip,com_ip_history,com_address,com_lat,com_long,com_memo,com_user_abbr,com_sms_mode,com_sms_user,com_sms_password,com_openkey_hostname,com_openkey_user,com_openkey_pass,com_openkey_abbr,com_radar_validator';
	
	public function create( $form )
	{
		$this->db->trans_start();
		
		$form['utype'] = $form['rec_id'] == 0 ? DomoUser::to_db_type(USER_TYPE_CPNY_META) : USER_TYPE_CPNY;
		
		CI()->load->model('User_model');

		CI()->User_model->add( $form['uname'], $form['upass'], $form['umail'], $form['utype'] );

		$uid = $this->db->last_insert_id();

		$com_id = $this->add( $uid, $form );

		$this->db->trans_complete();
		
		CI()->load->model('EventsTemplate_model');
		
		CI()->EventsTemplate_model->create_actions_for_company( $com_id );
		CI()->EventsTemplate_model->create_events_for_company( $com_id );
		
		load_model('DShieldEventStates_model')->create_default( $com_id );
		
		$this->get_api_key( $com_id );
		
		return $uid;
	}
	
	public function delete( $com_id )
	{
		$this->db->trans_start();
		
		$this->db->query( 'DELETE FROM actions_config WHERE ac_hw_id IN ( SELECT hw_id FROM hardware WHERE hw_company = ? )', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM actions_log WHERE al_hw_id IN ( SELECT hw_id FROM hardware WHERE hw_company = ? )', array( $com_id ) );
		
		load_model( 'AirmeshConfigLog_model' )->delete_from_company( $com_id );
		
		load_model( 'AvlEvent_model' )->delete_from_company( $com_id );
		
		load_model( 'AvlFleet_model' )->delete_from_company( $com_id );
		
		load_model( 'AvlHardware_model' )->delete_from_company( $com_id );
		
		load_model( 'CityMeshConfigLog_model' )->delete_from_company( $com_id );
		
		$this->db->query( 'DELETE FROM company_actions_tpl WHERE cat_company_id = ?', array( $com_id ) );
		
		load_model( 'CompanyAirmeshConfig_model' )->delete_from_company( $com_id );
		
		load_model( 'CompanyCityMeshConfig_model' )->delete_from_company( $com_id );
		
		$this->db->query( 'DELETE FROM company_events_tpl WHERE cet_company_id = ?', array( $com_id ) );
		
		load_model( 'CompanyNoiseConfig_model' )->delete_from_company( $com_id );
		
		load_model( 'CompanyTimeFrame_model' )->delete_from_company( $com_id );
		
		load_model( 'CompanyTimeFrameConfig_model' )->delete_from_company( $com_id );
		
		load_model( 'CompanyUser_model' )->delete_from_company( $com_id );
		
		load_model( 'GlobalEvent_model' )->delete_from_company( $com_id );
		
		$this->db->query( 'DELETE FROM hardware_actions_tpl WHERE hat_hw_id IN ( SELECT hw_id FROM hardware WHERE hw_company = ? )', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM hardware_events_tpl WHERE het_hw_id IN ( SELECT hw_id FROM hardware WHERE hw_company = ? )', array( $com_id ) );
		
		load_model( 'HardwareCityMeshCommand_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareConfigCommand_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareFake_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareGroup_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareHours_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareNoiseConfig_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareNoiseLog_model' )->delete_from_company( $com_id );
		
		load_model( 'HardwareSignalLog_model' )->delete_from_company( $com_id );
		
		load_model( 'Keychain_model' )->delete_from_company( $com_id );
		
		load_model( 'RadarEvent_model' )->delete_from_company( $com_id );
		
		load_model( 'Radar_model' )->delete_from_company( $com_id );
		
		load_model( 'ReceiverConsoleLog_model' )->delete_from_company( $com_id );
		
		load_model( 'ReceiverTicks_model' )->delete_from_company( $com_id );
		
		load_model( 'ReceiverTicksPeriod_model' )->delete_from_company( $com_id );
		
		load_model( 'Sms_model' )->delete_from_company( $com_id );
		
		load_model( 'Software_model' )->delete_from_company( $com_id );
		
		load_model( 'TestsLogCompanyGroup_model' )->delete_from_company( $com_id );
		
		load_model( 'TestsLogCompany_model' )->delete_from_company( $com_id );
		
		load_model( 'User_model' )->delete_from_company( $com_id );
		
		load_model( 'Hardware_model' )->delete_from_company( $com_id );
		
		$this->db->query( 'DELETE FROM users WHERE uid IN ( SELECT com_uid FROM company WHERE com_id = ? )', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM company WHERE com_id = ?', array( $com_id ) );
		
		$this->db->trans_complete();
	}
	
	public function add( $uid, $form )
	{
		$fields = array( 'df_id', 'rec_id', 'name', 'desc', 'phone', 'city', 'hw_report_freq', 'hw_state_low', 'hw_state_good', 'address', 'lat', 'long', 'memo', 'user_abbr', 'apikey', 'uid', 'sms_mode', 'sms_user', 'sms_password', 'openkey_hostname', 'openkey_user', 'openkey_pass', 'openkey_abbr' );
		$values = array( $form['df_id'], $form['rec_id'], $form['name'], $form['desc'], $form['phone'], $form['city'], $form['hw_report_freq'], $form['hw_state_low'], $form['hw_state_good'], $form['address'], $form['lat'], $form['long'], $form['memo'], $form['user_abbr'], '', $uid, $form['sms_mode'], $form['sms_user'], $form['sms_password'], $form['openkey_hostname'], $form['openkey_user'], $form['openkey_pass'], $form['openkey_abbr'] );
		
		$this->db->query( SQL::make_insert_pdo( 'company', $fields, '', 'com_' ), $values );
		
		return $this->db->last_insert_id();
	}
	
	public function update( $form )
	{
		$fields = array( 'df_id', 'rec_id', 'name', 'desc', 'phone', 'city', 'hw_report_freq', 'hw_state_low', 'hw_state_good', 'address', 'lat', 'long', 'memo', 'user_abbr', 'sms_mode', 'sms_user', 'sms_password', 'id' );
		$values = array( $form['df_id'], $form['rec_id'], $form['name'], $form['desc'], $form['phone'], $form['city'], $form['hw_report_freq'], $form['hw_state_low'], $form['hw_state_good'], $form['address'], $form['lat'], $form['long'], $form['memo'], $form['user_abbr'], $form['sms_mode'], $form['sms_user'], $form['sms_password'], $form['com_id'] );
		
		$this->db->query( SQL::make_update_pdo( 'company', $fields, 'id', '', 'com_' ), $values );
	}
	
	public function update_openkey( $form )
	{
		$fields = array( 'openkey_hostname', 'openkey_user', 'openkey_pass', 'openkey_abbr', 'id' );
		$values = array( $form['openkey_hostname'], $form['openkey_user'], $form['openkey_pass'], $form['openkey_abbr'], $form['com_id'] );
		
		$this->db->query( SQL::make_update_pdo( 'company', $fields, 'id', '', 'com_' ), $values );
	}
		
	public function get_api_key( $com_id )
	{
		$key = $this->db->get_var( 'SELECT com_apikey FROM company WHERE com_id = ?', array( $com_id ) );
		
		if( strlen( $key ) == 0 || $key == NULL ) //doesn't exists
		{
			do
			{
				$key = rand_string( 8 );
				
				$exists = $this->db->get_var( 'SELECT com_apikey FROM company WHERE com_apikey = ?', array( $key ) );
			} while( $exists != NULL );	
			
			$this->db->query( 'UPDATE company SET com_apikey = ? WHERE com_id = ?', array( $key, $com_id ) );
		}
		
		return $key;
	}
	
	public function get( $com_id, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_id = ?', $output, array( $com_id ) );
	}
	
	public function get_from_apikey_base( $api_key, $output = ARRAY_A )
	{
		return $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq, com_city FROM company WHERE com_apikey = ?', $output, array( $api_key ) );
	}
	
	public function get_from_user( $uid, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_uid = ?', $output, array( $uid ) );
	}
	
	public function get_from_apikey( $api_key, $output = OBJECT )
	{
		$this->db->set_qd( array( $api_key ) );
		
		return $this->db->get_row( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_apikey = ?', $output );
	}
	
	public function get_with_user( $com_id, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT ' . self::$def_fields . ', users.* FROM company INNER JOIN users ON com_uid = uid WHERE com_id = ? LIMIT 1', $output, array( $com_id ) );
	}
	
	public function owns_user( $com_id, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM users_info WHERE ui_company = ? AND ui_uid = ? LIMIT 1', array( $com_id, $uid ) );
	}
	
	public function owns_user_from_df( $com_df_id, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM users_info WHERE ui_company = ? AND ui_uid = ? LIMIT 1', array( $com_df_id, $uid ) );
	}
	
	public function owns_company_user( $com_id, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company_user WHERE cu_com_id = ? AND cu_user = ? LIMIT 1', array( $com_id, $uid ) );
	}
	
	public function owns_company_user_from_df( $com_df_id, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company_user INNER JOIN company ON com_df_id = ? WHERE cu_user = ? LIMIT 1', array( $com_df_id, $uid ) );
	}
	
	public function owns_hw( $com_id, $hw_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_company = ? AND hw_id = ? LIMIT 1', array( $com_id, intval( $hw_id ) ) );
	}
	
	public function owns_hw_from_df( $com_df_id, $hw_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_df_company = ? AND hw_id = ? LIMIT 1', array( $com_df_id, $hw_id ) );
	}
	
	public function owns_mac( $com_id, $hw_serial )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_company = ? AND hw_serial = ? LIMIT 1', array( $com_id, intval( $hw_serial ) ) );
	}
	
	public function owns_mac_from_df( $com_df_id, $hw_serial )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_df_company = ? AND hw_serial = ? LIMIT 1', array( $com_df_id, $hw_serial ) );
	}
	
	public function owns_hw_fake( $com_id, $hwf_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM hardware_fake WHERE hwf_company = ? AND hwf_id = ? LIMIT 1', array( $com_id, intval( $hwf_id ) ) );
	}

	public function owns_hw_fake_from_df( $com_df_id, $hwf_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT hwf_company FROM hardware_fake WHERE hwf_id = ? LIMIT 1 )', array( $com_df_id, $hwf_id ) );
	}
	
	public function get_ssh_port( $com_id )
	{
		$this->db->set_qd( array( $com_id ) );
		
		$port = $this->db->get_var( 'SELECT com_ssh_port FROM company WHERE com_id = ?' );
		
		if ( isset( $port ) &&  intval( $port ) > 0 )
		{
			return $port;
		}
				
		$rand_port = 0;
		
		do
		{
			$rand_port = mt_rand( 50000, 60000 );
			
			$this->db->set_qd( array( $rand_port ) );
			
			$count = $this->db->get_var( 'SELECT COUNT(com_ssh_port) FROM company WHERE com_ssh_port = ?' );
		} while ( $count > 0 );
		
		$this->db->set_qd( array( $rand_port, $com_id ) );
		
		$this->db->query( 'UPDATE company SET com_ssh_port = ? WHERE com_id = ?' );
		
		return $rand_port;
	}
	
	public function get_all_names( $filter_company = NULL, $output = OBJECT )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		return $this->db->get_results( "SELECT com_id, com_name FROM company $where ORDER BY com_name ASC", $output );
	}
	
	public function get_all( $filter_company = NULL )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		return $this->db->get_results( "SELECT " . self::$def_fields . " FROM company $where ORDER BY com_name ASC" );
	}
	
	public function get_all_basic_data( $filter_company = NULL, $output = OBJECT )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		return $this->db->get_results( "SELECT 
											com_id, com_df_id, com_rec_id, com_uid, com_name, com_city, com_apikey, 
											com_hw_count, com_ssh_port, com_hw_report_freq, com_hw_state_low, 
											com_hw_state_good, com_ip, com_ip_history 
										FROM company $where ORDER BY com_id ASC", $output );
	}
	
	public function get_all_with_user( $filter_company = NULL, $output = OBJECT, $order = 'ASC' )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		return $this->db->get_results( "SELECT " . self::$def_fields . ", users.* FROM company INNER JOIN users ON com_uid = uid $where ORDER BY com_name $order", $output );
	}
	
	public function get_company_name( $com_id )
	{
		return $this->db->get_var( 'SELECT com_name FROM company WHERE com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function get_city( $com_id )
	{
		return $this->db->get_var( 'SELECT com_city FROM company WHERE com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function exists( $com_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company WHERE com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function get_freq( $com_id )
	{
		return $this->db->get_var( 'SELECT com_hw_report_freq FROM company WHERE com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function get_user_abbr( $com_id )
	{
		return $this->db->get_var( 'SELECT com_user_abbr FROM company WHERE com_id = ? LIMIT 1', array( $com_id ) );
	}
	
	public function update_reports_data( $rep_freq, $state_low, $state_good, $com_id )
	{
		$keys	= array( 'hw_report_freq', 'hw_state_low', 'hw_state_good', 'id' );
		$values	= array( $rep_freq, $state_low, $state_good, $com_id );
		
		$this->db->set_qd( $values );
		
		$this->db->query( SQL::make_update_pdo( 'company', $keys, 'id', '', 'com_' ) );
	}
	
	public function get_hw_count( $com_id, $is_meta = FALSE )
	{
		return $is_meta ? 
					$this->db->get_var( 'SELECT COUNT(*) as hw_count FROM hardware WHERE hw_df_company = (SELECT com_df_id FROM company WHERE com_id = ? )', array( $com_id ) ):
					$this->db->get_var( 'SELECT COUNT(*) as hw_count FROM hardware WHERE hw_company = ?', array( $com_id ) );
	}
	
	public function get_global_info( $com_id )
	{
		$sql = "SELECT
					( SELECT COUNT(*) FROM users_info WHERE ui_company = $com_id ) AS users_count,
					( SELECT COUNT( sl_uid ) FROM site_log WHERE sl_uid = ANY ( SELECT ui_uid FROM users_info WHERE ui_company = $com_id ) AND sl_time > " . SQL::get_31_days_back() . " )  AS logins_count,
					( SELECT COUNT( al_hw_id ) FROM actions_log WHERE al_hw_id = ANY ( SELECT hw_id FROM hardware WHERE hw_company = $com_id ) AND al_time > " . SQL::get_31_days_back() . " ) AS actions_count";
		
		return $this->db->get_row( $sql );
	}
	
	public function get_table_info( $filter_company = NULL )
	{
		$where = SQL::get_or_filter( $filter_company, 'com_id' );
		
		SQL::prepare_filter( $where );
		
		$sql = "	SELECT	com_id,
							com_name,
							com_hw_count,
							com_uid,
							com_ssh_port,
							com_ip,
							com_ip_history,
							com_apikey,
							com_rec_id,
							loc_name,
							status.time AS time,
							COALESCE(status.alive,NULL) AS alive,
							COALESCE(logins.logins,0)+COALESCE(user_logins.logins,0) AS logins_count,
							COALESCE(" . SQL::format_timestamp('login_time.last') . ",'') AS last_login
					FROM company
					LEFT JOIN
						(
							SELECT	rt_company_id,
									( " . SQL::time_to_sec( '( NOW() - COALESCE(MAX(rt_time),NULL) )' ) . " - 600 ) AS time,
									CASE WHEN ( " . SQL::time_to_sec( '( NOW() - COALESCE(MAX(rt_time),NULL) )' ) . " - 600 ) < 0 THEN TRUE ELSE NULL END AS alive 
							FROM receiver_ticks 
							GROUP by rt_company_id
						) AS status ON rt_company_id = com_id 
					LEFT JOIN
						(
							SELECT sl_uid AS user_uid,COUNT(sl_uid) AS logins
							FROM site_log
							WHERE sl_time > " . SQL::get_31_days_back() . "
							GROUP BY user_uid
						) AS user_logins ON user_uid = com_uid
					LEFT JOIN
						(
							SELECT ui_company, COUNT( ui_uid ) AS logins 
							FROM users_info 
							INNER JOIN site_log ON sl_uid = ui_uid 
							WHERE sl_time > " . SQL::get_31_days_back() . "
							GROUP BY ui_company
						) AS logins ON ui_company = com_id
					LEFT JOIN
						(
							SELECT sl_uid, MAX(sl_time) AS last FROM site_log WHERE sl_event = 'USER_LOGGED_IN'
							GROUP BY sl_uid
						) AS login_time ON sl_uid = com_uid
					LEFT JOIN locations ON com_city = loc_id
					$where
					ORDER BY com_name ASC
		";
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_icons( $filter_company )
	{
		$where = SQL::get_or_filter( $filter_company, 'hw_company' );
		
		SQL::prepare_filter( $where );
		
		return $this->db->get_results( "SELECT hw_icon FROM hardware $where GROUP BY hw_icon", ARRAY_A );
	}
	
	public function is_meta( $com_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company WHERE com_id = ? AND com_rec_id = 0', array( $com_id ) );
	}
	
	public function get_companies_from_df( $com_df_id )
	{
		return $this->db->get_results( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_df_id = ? AND com_rec_id != 0', ARRAY_A, array( $com_df_id ) );
	}
	
	public function get_companies_from_df_with_meta( $com_df_id )
	{
		return $this->db->get_results( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_df_id = ?', ARRAY_A, array( $com_df_id ) );
	}
	
	public function get_company_from_df_anc_rec( $com_df_id, $com_rec_id )
	{
		return $this->db->get_row( 'SELECT ' . self::$def_fields . ' FROM company WHERE com_df_id = ? AND com_rec_id = ?', ARRAY_A, array( $com_df_id, $com_rec_id ) );
	}
	
	public function is_child_company( $real_uid, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ( SELECT com_df_id FROM company WHERE com_uid = ? ) AND com_rec_id != 0 AND com_uid = ?', array( $real_uid, $uid ) );
	}
	
	public function is_child_company_user( $real_uid, $uid )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM company_user INNER JOIN company AS cpny ON cu_com_id = cpny.com_id WHERE cu_user = ? AND cpny.com_df_id = ( SELECT com_df_id FROM company AS cpnyr WHERE com_uid = ? )', array( $real_uid, $uid ) );
	}
	
	public function get_report( $com_id )
	{
		return $this->db->get_var( 'SELECT com_report FROM company WHERE com_id = ?', array( $com_id ) );
	}
	
	public function get_receivers( $filter_company = NULL )
	{
		if ( isset( $filter_company ) )
		{
			$where = SQL::get_or_filter( $filter_company, 'com_id' );
		}
		else
		{
			$where = 'com_rec_id != 0';
		}
		
		SQL::prepare_filter( $where, array( 'filter' => 'NOT (com_lat = 0 AND com_long = 0 )' ) );
		
		$sql = 'SELECT
					com_id, com_df_id, com_rec_id, com_uid, com_name, com_desc, com_address, com_lat, com_long, loc_name, loc_desc
				FROM company
				INNER JOIN locations ON loc_id = com_id ' . $where;
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function update_report( $com_id, $report )
	{
		$this->db->query("UPDATE company SET com_report = ? WHERE com_id = ?", array( $report, $com_id ) );
	}
	
	public function count( $filter = '' )
	{
		return $this->search( $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function search( $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = NULL )
	{
		$fields_get		= NULL == $fields_get ? self::$def_fields . ', users.*, company_user.*' : $fields_get;
		$where			= '';
		$is_count		= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM company INNER JOIN company_user ON cu_com_id = com_id INNER JOIN users ON uid = cu_user ' . $where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function company_exists( $df_id, $rec_id )
	{
		return NULL != $this->db->get_var('SELECT 1 FROM company WHERE com_df_id = ? AND com_rec_id = ? LIMIT 1', array( $df_id, $rec_id ) );
	}
}
