<?php
class AvlHardware_model extends CI_Model
{
	/** ( ahw_imei ahw_name ahw_company ahw_icon ahw_state ahw_licenseplate ahw_uid ) */
	
	public function add( $imei, $name )
	{
		$this->db->query( SQL::make_insert_pdo( 'avl_hardware', array( 'imei', 'name' ), '', 'ahw_' ), array( $imei, $name ) );
		
		return $this->db->insert_id();
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM avl_hardware WHERE ahw_company = ?', array( $com_id ) );
	}
	
	public function add_cond( $imei, $name )
	{
		if ( NULL == $this->exists( $imei ) )
		{
			$id = $this->add( $imei, $name );
			
			$this->load->library('meitrack');
			
			$this->update_config( $imei, json_encode( $this->meitrack->get_default_config() ) );
			
			return $id;
		}
		
		return NULL;
	}
	
	public function get( $imei, $output = ARRAY_A )
	{
		return $this->db->get_row( 'SELECT * FROM avl_hardware 
									LEFT JOIN users_info ON ahw_uid = ui_uid 
									LEFT JOIN users ON ahw_uid = uid 
									LEFT JOIN avl_fleet ON ahw_fleet = af_id 
									WHERE ahw_imei = ? 
									LIMIT 1', $output, array( $imei ) );
	}
	
	public function get_ip_port( $imei )
	{
		return $this->db->get_row( 'SELECT ahw_ip, ahw_port FROM avl_hardware WHERE ahw_imei = ?', ARRAY_A, array( $imei ) );
	}
	
	public function get_config( $imei, $decode = TRUE )
	{
		$this->load->library('meitrack');
		
		$curcfg = $this->db->get_var( 'SELECT ahw_config FROM avl_hardware WHERE ahw_imei = ?', array( $imei ) );
		
		if ( !isset( $curcfg ) )
		{
			$cfg = json_encode( $this->meitrack->get_default_config() );
			
			$this->update_config( $imei, $cfg );
			
			return $decode ? $this->meitrack->get_default_config() : $cfg;
		}
		
		return $decode ? json_decode( $curcfg, TRUE ) : $curcfg;
	}
	
	public function get_for_map( $imei, $filter = NULL, $extra_fields = '' )
	{
		return $this->get_all_for_map( NULL, $filter, $imei, NULL, $extra_fields . 'ui_name, ui_lastname, ui_id, ' );
	}
	
	public function get_for_user( $uid, $filter = NULL, $extra_fields = '' )
	{
		return $this->get_all_for_map( NULL, $filter, NULL, $uid, $extra_fields );
	}
	
	public function exists( $imei )
	{
		return $this->db->get_var( 'SELECT 1 AS exists from avl_hardware WHERE ahw_imei = ? LIMIT 1', array( $imei ) );
	}
	
	public function company_owns_imei( $com_id, $imei )
	{
		return $this->db->get_var( 'SELECT 1 FROM avl_hardware WHERE ahw_company = ? AND ahw_imei = ? LIMIT 1', array( $com_id, $imei ) );
	}
	
	public function company_owns_imei_from_df( $com_df_id, $imei )
	{
		return $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT ahw_company FROM avl_hardware WHERE ahw_imei = ? LIMIT 1 )', array( $com_df_id, $imei ) );
	}
	
	public function user_owns_imei( $uid, $imei )
	{
		return $this->db->get_var( 'SELECT 1 FROM avl_hardware WHERE ahw_uid = ? AND ahw_imei = ? LIMIT 1', array( $uid, $imei ) );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= SQL::get_or_filter( $filter_company, 'ahw_company' );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM avl_hardware 
												LEFT JOIN users_info ON ahw_uid = ui_uid 
												LEFT JOIN users ON ahw_uid = uid 
												LEFT JOIN avl_fleet ON ahw_fleet = af_id ' .
												$where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function get_from_user( $uid )
	{
		$sql = "SELECT * FROM avl_hardware
				LEFT JOIN users_info ON ahw_uid = ui_uid 
				LEFT JOIN users ON ahw_uid = uid 
				WHERE ahw_uid = ?";
		
		return $this->db->get_results( $sql, ARRAY_A, array( $uid ) );
	}
	
	public function get_all_for_map( $filter_company = NULL, $filter = NULL, $imei = NULL, $uid = NULL, $extra_fields = '' )
	{
		$where				=	NULL == $imei ?
								(	NULL == $uid ?
									SQL::get_or_filter( $filter_company, 'ahw_company' ) :
									SQL::get_or_filter( $uid, 'ahw_uid' )
								) :
								SQL::get_or_filter( $imei, 'ahw_imei' );
		
		SQL::prepare_filter( $where, $filter, FALSE );
		
		$sql = "SELECT avl_hardware.*, 
				ae_imei, 
				ae_timestamp, 
				ae_speed, 
				ae_lat, 
				ae_long,
				ae_altitude, 
				ae_imei, 
				ae_code, 
				ae_hdop, 
				ae_gpsstatus, 
				ae_gpssatnum, 
				ae_gsmsignal, 
				ae_heading,
				( SELECT COUNT(*) FROM avl_event WHERE ae_code = 19 AND ae_imei = ahw_imei AND ( ( EXTRACT( EPOCH FROM ( NOW() ) )::bigint ) - ae_timestamp > 86400 * 7 ) ) AS speed_alert_count, 
				$extra_fields
				(	CASE WHEN ( ( EXTRACT( EPOCH FROM ( NOW() ) )::bigint ) - ae_timestamp > 86400 )
					THEN 'NOREPORT'
					ELSE 
						CASE WHEN ( ae_speed > 0 ) THEN 'MOVING'
						ELSE
							CASE WHEN ( ae_gpsstatus = 'V' ) THEN 'NOGPS'
							ELSE 'STOPPED'
							END
						END
					END
				) state
				FROM avl_hardware
				LEFT JOIN avl_event ON ae_imei = ahw_imei 
				LEFT JOIN users_info ON ahw_uid = ui_uid 
				LEFT JOIN users ON ahw_uid = uid
				LEFT JOIN avl_fleet ON af_id = ahw_fleet " . 
				$where;
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_autocomplete_by_imei( $filter_company, $uid = NULL, $name = NULL )
	{
		$where				=	SQL::get_or_filter( $filter_company, 'ahw_company' );
		$filter				=	array();
		$filter['filter']	=	NULL != $uid ? "ahw_uid = $uid AND" : '';
		$filter['filter']	.= 	NULL != $name ? "ahw_imei::varchar(15) ILIKE '%" . SQL::escape_string( $name ) . "%'" : '';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT ahw_imei AS id, ahw_imei AS name FROM avl_hardware $where", ARRAY_A );
	}
	
	public function get_autocomplete_by_name( $filter_company, $uid = NULL, $name = NULL )
	{
		$where				= 	SQL::get_or_filter( $filter_company, 'ahw_company' );
		$filter				= 	array();
		$filter['filter']	=	NULL != $uid ? "ahw_uid = $uid AND" : '';
		$filter['filter']	.= 	NULL != $name ? "ahw_name ILIKE '%" . SQL::escape_string( $name ) . "%'" : '';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT ahw_imei AS id, ahw_name AS name FROM avl_hardware $where", ARRAY_A );
	}
	
	public function get_autocomplete_by_user( $filter_company, $uid = NULL, $name = NULL )
	{
		$where				= 	SQL::get_or_filter( $filter_company, 'ahw_company' );
		$filter				= 	array();
		$filter['filter']	=	NULL != $uid ? "ahw_uid = $uid AND" : '';
		$filter['filter']	.= 	NULL != $name ? "ui_name ILIKE '%" . SQL::escape_string( $name ) . "%'" . ' OR ' . "ui_lastname ILIKE '%" . SQL::escape_string( $name ) . "%'" : '';
		
		SQL::prepare_filter( $where, $filter );
		
		return $this->db->get_results( "SELECT ahw_imei AS id, ahw_name AS name FROM avl_hardware
										INNER JOIN users ON ahw_uid = uid 
										INNER JOIN users_info ON ahw_uid = ui_id 
										$where", ARRAY_A );
	}
	
	public function update( $form, $user = NULL )
	{
		$fields = array( 'name'			, 'icon'		, 'state'		, 'licenseplate'		, 'model'			);
		$values = array( $form['name']	, $form['icon']	, $form['state'], $form['licenseplate']	, $form['model']	);
		
		if ( isset( $form['fleet'] ) )
		{
			$fields[]	= 'fleet';
			$values[]	= '' != $form['fleet'] ? intval( $form['fleet'] ) : NULL;
		}
		
		if ( isset( $form['user_id'] ) && !empty( $form['user_id'] ) && isset( $form['user_info_id'] ) && !empty( $form['user_info_id'] ) && NULL != $user && ( $user->is_logged_as_company() || $user->is_logged_as_god() ) )
		{
			if ( isset( $form['old_user_info_id'] ) && !empty( $form['old_user_info_id'] ) )
			{
				if ( intval( $form['user_info_id'] ) != intval( $form['old_user_info_id'] ) )
				{
					$fields[] = 'uid';
					$values[] = intval( $form['user_id'] );
				}
			}
			else
			{
				$fields[] = 'uid';
				$values[] = intval( $form['user_id'] );
			}
			
			$fields[]	= 'company';
			$values[]	= load_model('UserInfo_model')->get_company( intval( $form['user_id'] ) );
		}
		
		if ( isset( $form['company'] ) && NULL != $user && $user->is_logged_as_god() )
		{
			$fields[]	= 'company';
			$values[]	= '' != $form['company'] ? $form['company'] : NULL;
		}
		
		$fields[]	= 'imei';
		$values[]	= $form['imei'];
		
		return $this->db->query( SQL::make_update_pdo( 'avl_hardware', $fields, 'imei', '', 'ahw_' ), $values );
	}

	public function link( $imei, $uid )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'uid', 'imei' ), 'imei', '', 'ahw_' ), array( $uid, $imei ) );
	}
	
	public function unlink( $imei )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'uid', 'imei' ), 'imei', '', 'ahw_' ), array( NULL, $imei ) );
	}
	
	public function update_config( $imei, $config )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'config', 'imei' ), 'imei', '', 'ahw_' ), array( $config, $imei ) );
	}
	
	public function update_cmd_state( $imei, $state )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'cmd_state', 'imei' ), 'imei', '', 'ahw_' ), array( $state, $imei ) );
	}
	
	public function update_cmd_timestamp( $imei, $timestamp )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'cmd_timestamp', 'imei' ), 'imei', '', 'ahw_' ), array( $timestamp, $imei ) );
	}
	
	public function update_ip( $imei, $ip )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'ip', 'imei' ), 'imei', '', 'ahw_' ), array( $ip, $imei ) );
	}
	
	public function update_port( $imei, $port )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_hardware', array( 'port', 'imei' ), 'imei', '', 'ahw_' ), array( $port, $imei ) );
	}
}
